import Link from 'next/link'
import VideoModal from './VideoModal'

export default function PinnedVideo() {
  return (
    <>
    <section className="py-12 bg-[#f5f5f5] relative webminar-videos our-customer-stories">
          <div className="container mx-auto px-4">
            <div className="grid max-md:grid-cols-1 max-l:grid-cols-[43%_57%] max-xl:grid-cols-[49%_51%] grid-cols-[41%_59%] 2xl:grid-cols-[49%_51%] gap-0 max-l:mt-[-235px] mt-[-210px] justify-center items-stretch bg-white rounded-[20px] relative z-[1]">
              {/* Column 1 */}
              <div className="webminar-popup">
                  <VideoModal thumbnail="/images/webinars-card-01.jpg" videoSrc="/videos/helpcenter-video.mp4" />
              </div>
              {/* Column 2 */}
              <div className="news_details max-l:rounded-bl-[20px] bg-white max-md:p-[30px] p-[68px_64px_68px_78px] max-xl:py-[35px] max-xl:px-[35px] rounded-r-[20px] text-left relative">
                  <span className="news-label text-base text-[#713fff] font-medium mb-[30px] block underline">YourReviews announcements</span>
                  <Link className="card__link" href="#">
                    <h4 className="max-md:text-[26px] max-xl:text-[30px] lg:text-[36px] text-black font-nunito not-italic font-bold leading-[126%] tracking-[1.44px]">Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print.
                    </h4>
                  </Link>
                  <div className="news-time mt-[45px] flex flex-wrap gap-[10px] justify-between group">
                      <span className="date text-[#a39fac]">March 25. 2024</span>
                        <Link className="nav-arrow relative left-0 text-[24px] text-[#713fff] 
                          transition-all duration-300 group-hover:left-[10px]"
                          href="webinars-and-videos.html#"><i className="icon-arrow-thin-right"></i></Link>
                  </div>
              </div>
            </div>
          </div>  
        </section>
    </>
    );
}