import Link from 'next/link'



	export default function ModuleCards() {
		return(
			<>
			<section className="module-cards module-cards-bg max-md:pt-[90px] max-md:pb-[40px] pt-[92px] pb-[77px] bg-[#f5f5f5]">
	  			<div className="container mx-auto px-4">
			    <div className="text-center mx-auto mb-12 max-sm:mb-4">
			      <h2 className="mb-[14px]">All add-on modules to Standard</h2>
			      <p className="text-[#6d6d6d] text-[17px] max-sm:text-[14px] 2xl:text-lg mb-[12px] leading-[1.43]">Amplify your plan with optional add-ons for stronger results in key areas.</p>
			      <Link href="#" className="text-[#000] block text-lg max-sm:text-[14px] font-medium hover:underline">
			        Reach out for pricing and more info.
			      </Link>
			    </div>

			    <div className="grid grid-cols-1 max-l:grid-cols-1 sm:grid-cols-2 xl:grid-cols-3 gap-6 mx-auto">
			      {[
				  { title: 'Invite', img: 'invite--icon.svg' },
				  { title: 'Convert', img: 'convert--icon.svg' },
				  { title: 'Enhance', img: 'enhance--icon.svg' },
				  { title: 'Connect', img: 'connect--icon.svg' },
				  { title: 'Product Reviews', img: 'product--icon.svg' },
				  { title: 'Location Reviews', img: 'location--icon.svg' }
				].map((mod, i) => (
				  <div
				    key={i}
				    className="bg-white 2xl:flex 2xl:gap-[22px] 2xl:items-start mx-auto max-xl:w-[416px] max-ssm:w-full rounded-[20px] shadow-sm max-md:p-[30px] py-[37px] px-[42px] hover:shadow-md transition-all"
				  >
				    {/* Icon Image */}
				    <figure className="mb-6 max-sm:mb-4 2xl:mb-0 shrink-0">
				      <img
				        src={`images/${mod.img}`}
				        alt={`${mod.title} Icon`}
				        className="w-12 h-12 2xl:w-12 2xl:h-12"
				      />
				    </figure>

				    {/* Text Content */}
				    <div>
				      <h6 className="text-[20px] mb-[12px] font-bold">{mod.title}</h6>
				      <p className="text-[#6d6d6d] text-base max-sm:text-[15px] max-sm:mb-[20px] mb-[20px] font-bold">
				        Keep your review content fresh with unlimited automated review invitations
				      </p>
				      <p className="text-[#6d6d6d] text-base max-sm:text-[15px] max-sm:mb-[20px] mb-[20px] font-normal">
				        Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the
				        industry's standard dummy text.
				      </p>
				      <Link
				        href="#"
				        className="text-[#323232] text-base font-semibold underline inline-flex items-center gap-3 group"
				      >
				        Learn More
				        <svg
				          xmlns="http://www.w3.org/2000/svg"
				          className="w-[65px] h-[15px] transition-transform duration-300 group-hover:translate-x-2"
				          fill="none"
				          viewBox="0 0 65 15"
				        >
				          <image href="/images/arrow-long.svg" width="65" height="15 max-sm:hidden" />
				        </svg>
				      </Link>
				    </div>
				  </div>
				))}
				</div>

			    <div className="mt-[60px] max-l:mt-[40px] text-center">
			      <Link
			        href="#"
			        className="inline-block min-w-[130px] px-[35px] py-[14px] text-base font-semibold text-[#263238] border border-[#26323866] rounded-[5px] hover:bg-gray-100 transition"
			      >
			        Load More
			      </Link>
			    </div>
			  </div>
			</section>
			</>
			);
	}