import Image from 'next/image'
import Link from 'next/link'

export default function TrustedProgram(){
	return(
		<>
		<section className="image-article-block trusted-program max-l:py-[50px] max-xl:py-[60px] 
			max-xxl:py-[70px] max-3xl:py-[80px] pt-[90px] pb-[75px] bg-[#f5f5f5]">
		    <div className="container mx-auto px-4">
		        <div className="image-article-block-content flex max-l:flex-col max-l:gap-[22px] justify-between gap-[30px]">
		            <div className="text-area max-l:text-center max-l:max-w-full max-w-[530px] m-0 pl-0 max-xxl:p-0 max-l:order-2">
		                <h2 className="max-l:mb-[13px] mb-[23px]">Trusted Integration Program</h2>
		                <p className="mb-[30px] text-[#323232] max-sm:text-sm max-md:text-[15px] max-l:text-base max-xxl:text-[17px] 
		                	text-lg font-normal !leading-[1.43] tracking-[-0.1px]">
		                    Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been
		                    the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley
		                    of type and scrambled it to make a type specimen book.
		                </p>
		                <Link className="ms-btn primary-solid btn-xl max-l:!text-[16px] max-l:!py-[22px] max-l:!px-[30px]" href="">
		                Join the Program</Link>
		            </div>
		            <figure className="text-center flex-shrink-0 max-l:order-1 max-l:w-full">
		                <Image src="/images/trusted-integration-program.png" alt=""
		                	width={917}
		                	height={588}
		                	className="block max-w-[610px] max-l:mx-auto max-l:w-full"
		                />
		            </figure>
		        </div>
		    </div>
		</section>
		</>
		);
}