'use client';

import React, { useState } from 'react';
import Select, { SingleValue, StylesConfig } from 'react-select';
import Image from 'next/image'

interface OptionType {
  value: string;
  label: string;
}

const partnerOptions: OptionType[] = [
  { value: ' ', label: 'Partner Type' },
  { value: 'reseller', label: 'Reseller' },
  { value: 'vendor', label: 'Vendor' },
];

const countryOptions: OptionType[] = [
  { value: 'india', label: 'India' },
  { value: 'usa', label: 'USA' },
];

const customStyles: StylesConfig<OptionType, false> = {
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected
      ? '#f3f3f3'
      : state.isFocused
      ? '#f6f6f6'
      : 'white',
    color: '#8794a4',
    padding: 10,
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: state.isSelected ? '700' : '400',
  }),
  control: (base, state) => ({
    ...base,
    width: '100%',
    color: '#8794a4',
    fontWeight: 400,
    fontSize: 16,
    padding: '7px',
    border: '1px solid #dad6e5',
    borderRadius: 5,
    backgroundColor: '#fefefe',
    boxShadow: state.isFocused ? '0 0 0 1px #e8e8e8' : 'none',
    '&:hover': {
      borderColor: '#e8e8e8',
    },
  }),
  singleValue: (base) => ({
    ...base,
    maxWidth: '100%',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    color: '#8794a4',
    marginLeft: '2px',
    marginRight: '2px',
    fontWeight: 400,
    textAlign: 'left',
    // Responsive font size
  '@media (max-width: 991px)': {
    fontSize: '15px !important',
  },
  }),
  dropdownIndicator: (base, state) => ({
        ...base,
        color: '#8794a4',
        transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
        transition: 'transform 0.2s ease',
        svg: {
          fill: '#8794a4',
          stroke: '#8794a4',
          strokeWidth: 0,
      },
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
};

export default function InnerContactForm() {
  const [selectedPartner, setSelectedPartner] = useState<OptionType>(partnerOptions[0]);

  const handlePartnerChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedPartner(option);
  };

  const [selectedCountry, setSelectedCountry] = useState<OptionType>(countryOptions[0]);

  const handleCountryChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedCountry(option);
  };

  return (
    <section className="partners-banner inner-contact-form max-l:pb-[40px] max-xl:pb-[55px] max-3xl:pb-[68px] pb-[72px] bg-[#eaeef4]">
      <div className="container mx-auto px-4">
        <div className="inner-contact-form-content max-l:p-0 p-[35px] rounded-[22px] bg-white">
        <div className="row flex flex-wrap -mx-3">

          <div className="w-full xl:w-1/2 px-3">
          <div className="become-partner-form max-mmd:py-[25px] max-mmd:px-[20px] max-l:p-[35px] py-[12px] px-[35px]">
            <h4 className="max-md:text-[26px] max-xl:text-[30px] text-[32px] text-[#263238] mb-[20px] font-bold 
              font-nunito !leading-[1.07] text-center">
              Become a Partner Today</h4>
            <form className="grid max-sm:grid-cols-1 grid-cols-2 gap-y-[13px] gap-x-[12px]">
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="First name" />
              </div>
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]"
                  type="text" placeholder="Last name" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="email" placeholder="Business Email" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="Company Name" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <Select
                  options={partnerOptions}
                  value={selectedPartner}
                  onChange={handlePartnerChange}
                  classNamePrefix="react-select"
                  placeholder="Partner Type"
                  styles={customStyles}
                />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="url" placeholder="Website URL" />
              </div>
              <div className="form-field">
                <Select
                  options={countryOptions}
                  value={selectedCountry}
                  onChange={handleCountryChange}
                  classNamePrefix="react-select"
                  placeholder="Country"
                  styles={customStyles}
                />
              </div>
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="Phone number" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <button type="submit" className="ms-btn primary-solid btn-md w-full !block !mt-[5px] max-l:!py-[16px] !py-[14px] !px-[20px]
                  max-l:!text-[15px] !text-[16px]">
                  Send
                </button>
              </div>
            </form>
          </div>
        </div>

          <div className="w-full xl:w-1/2 px-3">
                <figure className="max-l:p-[0px_20px_25px_20px] py-[12px] px-[35px] rounded-[25px] overflow-hidden">
                    <Image src="/images/become-partner-today.jpg" alt="Image"
                      width={495}
                      height={472}
                      className="block mx-auto max-w-full rounded-[25px]"
                    />
                </figure>
          </div>

        </div>

      </div>

      </div>
    </section>
  );
}
