import Image from 'next/image'
import Link from 'next/link'

export default function ArticlesCommonHolder(){
	return(
		<>
		<section className="articles-common-holder pt-[103px]">
		    <div className="container mx-auto px-4">
		        <div className="article-block mb-6 max-md:py-[40px] max-md:px-[30px] py-[60px] px-[90px] 
		        	bg-[#f5f5f5] flex items-center rounded-[29px] max-xl:gap-0">
		            <div className="row flex flex-wrap -mx-3 -mt-6">
		                <div className="w-full lg:w-1/2 px-3 mt-6">
		                    <figure className="text-center">
		                        <Image src="/images/partner-with-your-review.svg" alt=""
		                        	width={456}
		                        	height={353}
		                        	className="max-w-[455px] w-full"
		                        />
		                    </figure>
		                </div>
		                <div className="w-full lg:w-1/2 px-3 mt-6">
		                    <div className="article-block--content order-1 max-xl:p-0 max-xl:text-center">
		                        <h3 className="max-sm:text-[28px] max-md:text-[32px] max-xl:text-[36px] text-[40px] 2xl:text-[48px] text-[#323232] font-nunito 
		                        	font-bold !leading-[1.10] mb-[25px]">
		                        	Partner with YourReview to syndicate Reviews</h3>
		                        <p className="text-[#6d6d6d] max-sm:text-[14px] max-md:text-[15px] max-l:text-base max-xxl:text-[17px] 
		                        	text-lg font-normal !leading-[1.58]">
		                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.
		                        </p>
		                        <Link className="ms-btn primary-solid btn-xl !mt-[45px] max-l:!py-[22px] max-l:!px-[30px] max-l:!text-[16px] 
		                        	!py-[24px] !px-[55px] !text-[20px]" href="/#">
			                        Join the Program
			                    </Link>
		                    </div>
		                </div>
		            </div>
		        </div>

		        <div className="article-block max-md:py-[40px] max-md:px-[30px] py-[60px] px-[90px] 
		        	bg-[#f5f5f5] flex items-center rounded-[29px] max-xl:gap-0">
		            <div className="row flex flex-wrap-reverse lg:flex-row-reverse -mx-3 -mt-6">
		                <div className="w-full lg:w-1/2 px-3 mt-6">
		                    <figure className="text-center">
		                        <Image src="/images/increase-conversions-with-verified.svg" alt=""
		                        	width={455}
		                        	height={344}
		                        	className="max-w-[455px] w-full"
		                        />
		                    </figure>
		                </div>
		                <div className="w-full lg:w-1/2 px-3 mt-6">
		                    <div className="article-block--content order-1 max-xl:p-0 max-xl:text-center">
		                        <h3 className="max-sm:text-[28px] max-md:text-[32px] max-xl:text-[36px] text-[40px] 2xl:text-[48px] text-[#323232] font-nunito 
		                        	font-bold !leading-[1.10] mb-[25px]">
		                        	Increase Conversions with verified Reviews</h3>
		                        <p className="text-[#6d6d6d] max-sm:text-[14px] max-md:text-[15px] max-l:text-base max-xxl:text-[17px] 
		                        	text-lg font-normal !leading-[1.58]">
		                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.
		                        </p>
		                        <Link className="ms-btn primary-solid btn-xl !mt-[45px] max-l:!py-[22px] max-l:!px-[30px] max-l:!text-[16px] 
		                        	!py-[24px] !px-[55px] !text-[20px]" href="/#">
			                        Join the Program
			                    </Link>
		                    </div>
		                </div>
		            </div>
		        </div>
		        
		        
		    </div>
		</section>
		</>
		);
}