import Link from 'next/link'

export default function StoryIntroVideo() {
	return(
		<>
		<section className="story-intro-video">
		  <div className="container mx-auto px-4">
		    <div className="flex flex-col llg:flex-row gap-[28px]">
		      <div className="max-xl:w-full max-xxl:w-[59%] w-[60%]">
		        <video
		          className="w-full rounded-[20px] shadow-lg h-[485px] object-cover"
		          poster="/videos/our_stories__video-thumb.jpg"
		          controls
		        >
		          <source src="/videos/our_stories__video.mp4" type="video/mp4" />
		        </video>
		      </div>

		      <div className="section-content max-xl:px-[30px] max-xl:text-center max-xl:py-[50px] max-xl:w-[520px] max-xl:mx-auto max-xl:w-full max-xxl:w-[41%] w-[40%] rounded-[20px] bg-white py-[40px] px-[45px]">
		        <h3 className="text-[40px] font-bold font-nunito mb-[15px] leading-[1.20]">We're YourReview</h3>
		        <p className="text-base 2xl:text-lg font-medium text-[#6d6d6d] leading-[1.56]">
		          Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		          Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, 
		          when an unknown printer took a galley of type and scrambled it to make a type specimen book. 
		          It has survived not only five centuries, but also the leap into electronic typesetting, 
		          remaining essentially unchanged.
		        </p>
		        <Link href="#"
		          className="inline-block mt-[30px] max-l:py-[22px] max-l:text-base bg-[#713fff] text-white text-[20px] font-semibold px-[55px] py-[24px] rounded-[3px] shadow hover:bg-[#713fffcc] transition"
		        >we’re hiring</Link>
		      </div>

		    </div>
		  </div>
		</section>
		</>
		);
}