'use client';
import React from 'react';
import Image from 'next/image'

export default function ReviewSlider() {

  return (
    <>
    <section className="review-container bg-[#efedf5] pt-[165px]">
      <div className="w-full">
        <div className="section-heading max-w-[1078px] text-center pb-[39px] mx-auto">
          <h3 className="mb-[15px] max-sm:text-[28px] max-md:text-[32px] max-xl:text-4xl text-[40px] font-bold">See what people are saying about YourReview</h3>
          <p className="text-lg font-medium">We aim to continuously improve, and every review helps us provide better experiences for everyone.</p>
        </div>
        <div className="review-slide">
          <div className="review-slides relative overflow-hidden w-full py-4 group">
            <div className="flex gap-1 animate-marquee-reverse w-max group-hover:[animation-play-state:paused]">
  {/*items start*/}

              {[...Array(2)].map((_, index) => (
                <React.Fragment key={`group-${index}`}>
                  {[...Array(9)].map((_, i) => (
                    <div key={`${index}-${i}`} className="item flex-shrink-0 w-[26rem] mx-2">
                      <div className="review-card">
                        <div className="heading flex space-x-4">
                          <Image
                            className="card-profile-image w-12 h-12 rounded-full"
                            src={`/images/profile-image-${i + 1}.jpg`}
                            alt=""
                            width={50}
                            height={50}
                          />
                          <div className="profileData flex">
                            <h6 className="name">Gabi Guerra {i + 1}</h6>
                            <span className="status">reviewed Post</span>
                            <a href="#" className="post-lake">Lake Lending</a>
                          </div>
                        </div>
                        <ul className="star-rating flex space-x-1 mb-4">
                          {[...Array(5)].map((_, starIndex) => (
                            <li key={starIndex}>
                              <img src="images/gray-star_rating.svg" alt="" />
                            </li>
                            ))}
                        </ul>
                        <p className="text-sm text-gray-700">
                          Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
                          Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took.
                        </p>
                      </div>
                    </div>
                    ))}
                </React.Fragment>
                ))}

  {/*items end*/}
              

            </div>
          </div>
        </div>
      </div>
    </section>

    </>
    );
}

