import Image from 'next/image'

export default function CeoQuote(){
	return(
		<>
		<section className="story-ceo-quote pt-[160px] pb-[64px]">
			<div className="container mx-auto px-4">
				<div className="grid grid-cols-1 lg:grid-cols-2 gap-8 items-start">
					
					<div className="section-image max-w-[500px] mx-auto relative">
						<Image 
							src="/images/ceo-your_review.jpg" 
							alt="CEO YourReview"
							width={500}
							height={372}
							className="w-full h-full object-cover rounded-[10px] z-[1] relative"
						/>
					</div>

					<div className="section-content text-left max-md:px-5">
						<p className="font-nunito max-md:text-xl text-[28px] font-medium leading-[1.49] text-[#323232]">
							“Our aspiration is to evolve into a ubiquitous emblem of trust, enabling consumers to make assured, well-informed purchasing choices, while enabling businesses to authentically demonstrate the caliber of their offerings and to glean valuable insights for enhancement”
						</p>
						<div className="name-details mt-[60px]">
							<h6 className="text-lg font-bold text-[#713fff] ">Jhoe Deo</h6>
							<span className="text-[#666] text-base font-normal">CEO, YourReview</span>
						</div>
					</div>

				</div>
			</div>
		</section>
		</>
		);
}