import Image from 'next/image'
import Link from 'next/link'

export default function UserFriendly() {
	return (
		<>
			<section className="py-10 brief-user-friendly">
			  <div className="container mx-auto px-4">
			    <div className="flex flex-col lg:flex-row-reverse items-start section-holder max-xl:gap-x-[20px]">
			      <div className="lg:w-7/12 max-xl:px-[0px] px-3">
			      	<div className="section-content max-l:pl-[0px] pl-[50px]">
				        <h2 className="pb-5">
				          Less complicated and better User-friendly than other review sites
				        </h2>
				        <p className="max-sm:text-[14px] max-md:text-[15px] max-l:text-[16px] max-xxl:text-[17px] 2xl:text-[18px]">
				        	Your.Reviews is built for simplicity, eliminating the frustration of complex review platforms. 
				        	Our intuitive design makes it easy to collect, manage, and analyse reviews, ensuring businesses 
				        	and customers can navigate effortlessly. Enjoy a seamless experience without unnecessary complications 
				        	or hidden fees.
				        </p>
				        <div className="text-center">
				          <Link
				            href="/#"
				            className="ms-btn primary-solid btn-xl primary-button max-l:!text-[16px] max-l:!py-[22px] mt-[45px]
				            hover:bg-[#713fffcc]"
				          >
				            Get Started
				          </Link>
				        </div>
				    </div>
			      </div>
			      <div className="lg:w-5/12 flex justify-center max-xl:px-[0px] px-3">
			        <Image
			          src="images/image-user-friendly.svg"
			          alt="User Friendly"
			          width={481}
			          height={462}
			          className="section-image w-full max-w-[480px] h-auto max-l:mt-[48px]"
			        />
			      </div>
			    </div>
			  </div>
			</section>
		</>
		);
}