import Image from 'next/image'
import Link from 'next/link'
import VideoSection from './VideoSection';

export default function LandingIntro() {
  return (
    <>
      <section className="landing-intro relative overflow-hidden">
          <div className="container mx-auto pd3">
              <div className="intro-container">
                  <div className="flex flex-col lg:flex-row gap-5 llg:gap-10">
                      <div className="w-full lg:w-1/2 llg:w-[42%] mx-auto VideoSection">
                          <div className="video-container mx-auto" id="intro_video_section">
                              <VideoSection />
                              <div className="rating-demo max-l:!py-[8px] max-l:!px-[25px]">
                                  <span className="max-md:!mr-[0px] max-l:!mr-[8px] pr-[5px]">
                                    <Image src="/images/purple-star-glod.png" alt=""width={49} height={48} 
                                      className="max-md:h-[35px] max-md:w-[35px] "/></span>
                                  <span className="max-md:!mr-[0px] pr-[5px]">
                                    <Image src="/images/purple-star-glod.png" alt=""width={49} height={48} 
                                      className="max-md:h-[35px] max-md:w-[35px] "/></span>
                                  <span className="max-md:!mr-[0px] pr-[5px]">
                                    <Image src="/images/purple-star-glod.png" alt=""width={49} height={48} 
                                      className="max-md:h-[35px] max-md:w-[35px] "/></span>
                                  <span className="max-md:!mr-[0px] pr-[5px]">
                                    <Image src="/images/purple-star-glod.png" alt=""width={49} height={48} 
                                      className="max-md:h-[35px] max-md:w-[35px] "/></span>
                                  <span>
                                    <Image src="/images/purple-star-glod.png" alt=""width={49} height={48} 
                                      className="max-md:h-[35px] max-md:w-[35px] "/></span>
                              </div>
                          </div>
                      </div>
                      <div className="w-full lg:w-1/2 llg:w-[58%] flex flex-col justify-center col-right !z-[-5]">
                          <div className="section-content max-l:!mt-[70px] max-xl:!pl-0 !mt-0">
                              <h4 className="max-md:!text-[26px] max-xl:!text-[30px] !mb-[15px]">Why we're your best choice</h4>
                              <p className="max-w-[580px] max-sm:!text-[14px] max-md:!text-[15px] max-l:!text-base mb-[10px]
                                tracking-[-0.2px] max-xl:!text-[15px]">
                                At Your.Reviews, we're dedicated to enhancing your business's online presence through 
                                genuine and insightful customer feedback. Our experienced team leverages cutting-edge 
                                technology to filter out fake reviews, ensuring that only authentic voices are heard. 
                                With our user-friendly platform, you can easily manage reviews, gain valuable insights 
                                through advanced analytics, and boost your visibility on search engines.
                              </p>
                              <p className="max-w-[580px] max-sm:!text-[14px] max-md:!text-[15px] max-l:!text-base mb-[20px]
                                tracking-[-0.2px] max-xl:!text-[15px]">
                                By partnering with us, you'll benefit from our commitment to quality and transparency, 
                                allowing you to make informed decisions that propel your business forward. Our services 
                                are designed to be flexible, catering to your unique needs and helping you cultivate a 
                                trustworthy brand that attracts and retains customers.
                              </p>
                              <p  className="join-us heading-label max-xl:!text-[15px]">
                                <Link href="/#">
                                  Join Us Today
                                </Link>
                              </p>
                              <p className="max-w-[580px] max-sm:!text-[14px] max-md:!text-[15px] max-l:!text-base 
                                max-xl:!text-[15px]">
                                Let us help elevate your business. Contact us to discover more about our innovative review 
                                management solutions.
                              </p>
                              <div className="text-center">
                                <Link className="ms-btn primary-solid btn-xl max-l:!text-[16px] max-l:!py-[22px] max-l:!px-[30px] 
                                  !mt-[30px] hover:bg-[#713fffcc]" 
                                href="/#">Write a review
                                </Link>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </section>
    </>

    );
}