import Image from 'next/image'
import Link from 'next/link'

const InnerBanner = () => (
  <section className="relative overflow-hidden hero-banner landing-banner">
        <div className="container mx-auto pd3">
          <div className="text-center banner-content">
            <Image
              src="/images/logo-your-review.png" alt="YourReview Logo" width={250} height={71} className="mx-auto mb-11 banner-logo"/>
            <h1>
              Make Smarter Choices with Your Reviews
            </h1>
            <div className="site-search">
              <input
                type="text"
                placeholder="Search a Business or product Name"
                className="form-control"
              />

              <span className="search-icon">
                <i className="icon-search text-[#b1b1b1] text-[22px]"></i>
              </span>
            </div>
            <Link
              href="/#"
              className="ms-btn primary-solid inline-block bg-[#713fff] text-white px-6 py-3 rounded-lg font-semibold 
              hover:bg-[#713fffcc] transition"
            >
              List Your Product or Business
            </Link>
          </div>
        </div>
      </section>
);

export default InnerBanner;
