'use client';
import { useState } from "react";
import { motion, AnimatePresence } from "framer-motion";
import Image from 'next/image'
import Link from 'next/link'

const faqs = [
  {
    question: "What types of reviews does your platform support?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How does your AI detect fake reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can businesses respond to reviews on your platform?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can users report suspicious reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How can businesses integrate your review analysis into their systems?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
];

export default function FAQSection() {
  const [openIndex, setOpenIndex] = useState<number | null>(null);

  const toggleIndex = (index: number) => {
    setOpenIndex(openIndex === index ? null : index);
  };

  return (
      <section className="faq-main faq-bg py-[75px]">
        <div className="container mx-auto px-4">
        <div className="flex flex-col lg:flex-row max-l:gap-0 gap-12 faq-holder max-sm:!px-[10px] max-sm:!py-[30px] max-md:!p-[30px]">
          <div className="lg:w-1/3">
            <div className="section-heading max-l:text-center">
              <Image 
                src="/images/faq-image.png" alt="faq-image" 
                width={273}
                height={188}
                className="mb-[50px] mt-[10px] h-[184px] max-l:mx-auto" />
              <h2 className="text-[26px] max-xxl:leading-[32px] leading-[38px] font-bold max-l:max-w-[420px] max-l:mb-[20px] max-l:mx-auto">
                Explore FAQ’s: Find Solutions Here About{" "}
                <span className="text-[#713fff]">Your.Review</span>
              </h2>
            </div>
          </div>
          <div className="lg:w-2/3">
            <div className="faq-wrapper block w-full">
            {faqs.map((faq, index) => (
                <div
                  key={index}
                  className="faq-item w-full block max-l:px-[20px] bg-white"
                >
                  <div
                    className="flex gap-4 items-baseline"
                    onClick={() => toggleIndex(index)}
                  >
                    <img
                      src={openIndex === index ? "/images/faq-active.svg" : "/images/faq-inactive.svg"}
                      alt={openIndex === index ? "Collapse" : "Expand"}
                      className="shrink-0 max-sm:hidden w-[15px] h-[15px]"
                    />
                    <h4 className="p-[15px_20px_15px_0px] text-[#1c070c] max-md:text-[16px] 
                      max-xl:text-[18px] text-[20px] relative font-semibold">
                      {faq.question}
                    </h4>
                  </div>

                  <AnimatePresence initial={false}>
                    {openIndex === index && (
                      <motion.div
                        initial={{ height: 0, opacity: 0 }}
                        animate={{ height: "auto", opacity: 1 }}
                        exit={{ height: 0, opacity: 0 }}
                        transition={{ duration: 0.3 }}
                        className="overflow-hidden max-sm:pl-[0px] pl-[40px] max-l:pr-[40px] pr-[48px]"
                      >
                        <p className="text-gray text-[16px] leading-[1.54] mt-2">{faq.answer}</p>
                      </motion.div>
                    )}
                  </AnimatePresence>
                </div>
            ))}
          </div>
            <div className="action max-l:text-center">
              <Link className="primary-link max-l:pl-[0px] max-l:!text-center max-l:!mt-[20px] !mt-[20px] !pl-[31px]" href="/#">
                Explore more FAQ’s 
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
