'use client';

import Image from 'next/image';

import Link from 'next/link';

import { useState } from 'react';

export default function MobileSidebarMenu() {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <>
      {/* Mobile Header */}
      <div className="llg:hidden flex justify-between px-4 py-3 bg-white shadow-md z-50 mobile-header">
        <div className="logo">
        <Link href="/">
        <Image
          src="/images/logo-your-reivew.png"
          alt="Logo"
          width={120}
          height={32}
          className="h-8 main-logo max-md:!h-[38px] w-auto"
        />
        </Link>
        </div>
        <button onClick={() => setIsOpen(true)} className="flex flex-col gap-1.5 ms-menu">
          <span className="w-7 h-0.5 bg-gray-800 ms-menu-line"></span>
          <span className="w-7 h-0.5 bg-gray-800 ms-menu-line"></span>
          <span className="w-7 h-0.5 bg-gray-800 ms-menu-line"></span>
        </button>
      </div>

      {/* Overlay */}
      <div
        onClick={() => setIsOpen(false)}
        className={`fixed inset-0 bg-black bg-opacity-80 z-40 transition-opacity duration-300 ${
          isOpen ? 'opacity-100 visible' : 'opacity-0 invisible'
        }`}
      ></div>

      {/* Sidebar */}
      <div
        className={`fixed top-0 left-0 h-full w-72 max-w-[90%] bg-white z-50 shadow-lg transform transition-transform duration-300 ${
          isOpen ? 'translate-x-0' : '-translate-x-full'
        }`}
      >
        {/* Header Row with Logo + Close */}
        <div className="flex justify-between item-center px-5 py-4 border-b">
          <Link href="/">
            <Image
              src="/images/logo-your-reivew.png"
              alt="Logo"
              width={100}
              height={28}
              className="h-7 w-auto"
            />

          </Link>
          <button onClick={() => setIsOpen(false)} className="text-3xl text-gray-500 hover:text-black">
            ×
          </button>
        </div>

        {/* Menu Items */}
        <nav className="overflow-y-auto h-[calc(100vh-72px)] px-5 py-4">
          <ul className="space-y-4 mob-menu">
            <li><Link href="/pricing" className="block pb-2 border-b hover:text-black">Plans</Link></li>
            <li><Link href="/customer-stories" className="block pb-2 border-b hover:text-black">Reviews</Link></li>
            <li><Link href="/webinars" className="block pb-2 border-b hover:text-black">Resources</Link></li>
            <li><Link href="/our-story" className="block pb-2 border-b hover:text-black">About</Link></li>
            <li><Link href="/customer-register-login" className="block pb-2 border-b hover:text-black">Join</Link></li>
            <li><Link href="/business-registration-login" className="block pb-2 border-b hover:text-black">Sign in</Link></li>
            <li><Link href="/business-registration-login" className="block pb-2 border-b hover:text-black">Business</Link></li>
          </ul>
        </nav>
      </div>
    </>
  );
}
