'use client';

import { usePathname } from 'next/navigation';
import { useEffect, useState } from 'react';
import HomeHeader from '../Header/HomeHeader';
import BlogHeader from '../Header/BlogHeader';
import DefaultHeader from '../Header/DefaultHeader';

const ClientHeaderWrapper = () => {
  const pathname = usePathname();
  const [isMounted, setIsMounted] = useState(false);

  useEffect(() => {
    setIsMounted(true);
  }, []);

  if (!isMounted) return null; // Prevents hydration mismatch

  const isHome = pathname === '/';
  const isBlog = pathname.startsWith('/news-and-updates');
  const isBlogDetails = pathname.startsWith('/news-and-updates-details/') && pathname.split('/').length > 2;
  const isBusinessDetail = pathname.startsWith('/business-detail');
  const isPartners = pathname.startsWith('/partners');
  const isProductDetails = pathname.startsWith('/products/') && pathname.split('/').length > 2;

  if (isHome) return <HomeHeader />;
  if (isBlog || isBlogDetails || isBusinessDetail || isPartners || isProductDetails) return <BlogHeader />;
  return <DefaultHeader />;
};

export default ClientHeaderWrapper;
