import Image from 'next/image'
import Link from 'next/link'
import Faq from './Faq'

export default function GuiedlinesHolder(){
	return(
		<>
		<section className="guiedlines-holder pb-[97px] relative bg-[#f5f5f5]">
		    <div className="container mx-auto px-4">
		        <div className="section-holder relative z-[1]">
		            <div className="row flex flex-wrap -mx-3">
		                <div className="w-full lg:w-1/3 px-3">
		                    <div className="side-links max-xl:p-[25px] p-[38px_42px_54px_42px] bg-white rounded-[16px]">
		                        <div className="side-links--group mb-[36px]">
		                            <h6 className="text-[#000000] text-xl font-bold !leading-[1.51] mb-[7px]">
		                            	For Reviewers
		                            </h6>
		                            <ul>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Guidelines for Reviewers
		                                	</Link>
		                            	</li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Privacy Policy
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
			                                	Terms of Use for Consumers
			                                </Link>
		                            	</li>
		                            </ul>
		                        </div>
		                        <div className="side-links--group mb-[36px]">
		                            <h6 className="text-[#000000] text-xl font-bold !leading-[1.51] mb-[7px]">
		                            	For Reviewers
		                            </h6>
		                            <ul>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                	Guidelines for Business
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Terms of Use and Sale for Businesses
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Data Processing Agreement
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Subprocessors
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		U.S. Privacy Laws Supplement
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		HIPAA Business Associate 
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Addendum
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Privacy Policy
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Content Refresh Guidelines
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Legal Brand Guidelines
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		SEO requirements for partners
		                                	</Link>
		                                </li>
		                            </ul>
		                        </div>
		                        <div className="side-links--group">
		                            <h6 className="text-[#000000] text-xl font-bold !leading-[1.51] mb-[7px]">
		                            	For Reviewers
		                            </h6>
		                            <ul>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Code of Ethics
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Action We Take
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Diversity, Equity and Inclusion Policy
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Anti-Bribery & Corruption Policy
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Modern Slavery Code of Conduct
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Copyright Dispute Policy
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Cookie Policy
		                                	</Link>
		                                </li>
		                                <li className="mb-[12px]">
		                                	<Link className="relative pl-[30px] text-[#5b5866] text-[16px] font-normal 
		                                		!leading-[150%] underline underline-offset-auto decoration-solid" 
		                                		href="/#">
		                                		Accessibility Statement
		                                	</Link>
		                                </li>
		                            </ul>
		                        </div>
		                    </div>
		                </div>
		                <div className="w-full lg:w-2/3 px-3 max-l:mt-[48px]">
		                    <div className="guideline-details">
		                        <figure className="top-image m-0">
		                            <Image src="/images/image-guideline-detail.jpg" alt=""
		                            	width={807}
		                            	height={404}
		                            	className="max-w-[807px] w-full mb-[37px] rounded-[17px]"
		                            />
		                            <p className="max-w-[720px] text-[#808080] max-sm:text-[14px] max-md:text-[15px] max-l:text-base max-xxl:text-[17px] 
		                            	text-lg font-medium !leading-[1.51]">
		                            	Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		                            	Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, 
		                            	Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		                            	Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, 
		                            </p>
		                        </figure>
		                        {/*FAQ*/}
		                        <Faq />
		            
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}