'use client';

import Link from 'next/link';

const Footer = () => {
  const currentYear = new Date().getFullYear();
  
  return (
    <footer className="footer-section">
      <div className="container mx-auto px-4">
        {/* Footer Top */}
        <div className="flex flex-col lg:flex-row items-center gap-8 justify-between border-b border-gray-700  footer-top">
          <div className="w-full flex flex-col md:flex-row gap-4 left-col">
            <Link href="/" className="footer-logo">
              <img src="/images/logo-your-reivew-white.png" alt="Your Review Logo" />
            </Link>
            <ul className="flex text-sm login-links">
              <li><Link href="/business-registration-login" className="hover:underline">Login</Link></li>
              <li><Link href="/business-registration-login" className="hover:underline">Signup</Link></li>
            </ul>
          </div>
          <div className="w-full lg:w-1/2 flex justify-start sm:justify-center lg:justify-end right-col">
            <ul className="flex space-x-1 social-links">
              {["facebook", "x", "youtube", "linkedin"].map((icon: string) => (
                <li key={icon}>
                  <Link href="/#">
                    <img src={`/images/social-icon-${icon}.svg`} alt={icon} />
                  </Link>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* Footer Content Links */}
        <div className="grid grid-cols-1 sm:grid-cols-2 md:gap-4 lg:grid-cols-[1.5fr_1.6fr_1.3fr_1.2fr_1fr] footer-content">
          {/* About */}
          <div className="footer-links col_1">
            <h6>About</h6>
            <ul>
              <li><Link href="/how-yourreviews-works">How Your Reviews works</Link></li>
              <li><Link href="/our-story">Our story</Link></li>
              <li><Link href="/what-we-believe">What we believe</Link></li>
              <li><Link href="/blog">Blog</Link></li>
              <li><Link href="/news-and-updates">Press</Link></li>
              <li><Link href="/your-review-legal">Your Review Legal</Link></li>
              <li><Link href="/investor-relations">Investor Relations</Link></li>
            </ul>
          </div>

          {/* Community */}
          <div className="footer-links col_2">
            <h6>Community</h6>
            <ul>
              <li><Link href="/join-the-comunnity">Join the community</Link></li>
              <li><Link href="/#">Leave a review</Link></li>
              <li><Link href="/business-listing">Search for a company</Link></li>
            </ul>
          </div>

          {/* Businesses */}
          <div className="footer-links col_3">
            <h6>Businesses</h6>
            <ul>
              <li><Link href="/features">Features</Link></li>
              <li><Link href="/pricing">Pricing</Link></li>
              <li><Link href="/partners">Partners</Link></li>
              <li><Link href="/agency-partners">Agency partners</Link></li>
              <li><Link href="/partners">Become a partner</Link></li>
            </ul>
          </div>

          {/* Resources */}
          <div className="footer-links col_4">
            <h6>Resources</h6>
            <ul>
              <li><Link href="/#">Business Blog</Link></li>
              <li><Link href="/webinars">Webinars and Videos</Link></li>
              <li><Link href="/guidelines">Guides and Reports</Link></li>
              <li><Link href="/customer-stories">Customer Stories</Link></li>
              <li><Link href="/#">Developers</Link></li>
              <li><Link href="/#">Tech blog</Link></li>
              <li><Link href="/#">System status</Link></li>
              <li><Link href="/#">API Documentation</Link></li>
            </ul>
          </div>

          {/* Contact */}
          <div className="footer-links col_5">
            <h6>Contact</h6>
            <ul>
              <li><Link href="/contact-sales">Contact Sales</Link></li>
              <li><Link href="/help-center">Help Center</Link></li>
              <li><Link href="/our-offices">Our offices</Link></li>
            </ul>
          </div>
        </div>

        {/* Footer Bottom */}
        <div className="flex flex-col lg:flex-row justify-between footer-bottom">
          <p className="text-center lg:text-left mb-2 lg:mb-0">©{currentYear} Your Review Pty. Ltd. All rights reserved.</p>
          <ul className="flex flex-wrap justify-center lg:justify-end privacy-links">
            <li><Link href="/#" className="hover:underline">Privacy Policy</Link></li>
            <li><Link href="/#" className="hover:underline">Terms & Conditions</Link></li>
            <li><Link href="/guidelines" className="hover:underline">Guidelines for Reviewers</Link></li>
          </ul>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
