import Image from 'next/image'

export default function ReviewsCards() {
	return (
		<>
		<section className="reviews-cards bg-[#f5f5f5]">
	        <div className="container mx-auto px-4">
	          <div className="card-grid grid grid-cols-2 max-md:grid-cols-1 gap-6">
	            {[1, 2, 3, 4, 5, 6].map((i: number) => (
	              <div
	                key={i}
	                className="reviews-card bg-white p-8 rounded-[20px] shadow-md flex flex-col gap-4 max-md:py-[30px] max-md:px-[20px]"
	              >
	                <div className="flex gap-4 items-start">
	                  <Image
	                    className="w-[43px] h-[43px] rounded-full object-cover"
	                    src={`/images/profile-image-${i}.jpg`}
	                    alt={`Profile ${i}`}
	                    width={50}
	                    height={50}
	                  />
	                  <article>
	                    <span className="block text-black font-bold font-nunito mb-[3px] profile-name leading-[1.20]">Gabi Guerra</span>
	                    <span className="block text-[#a39fac] text-[12px] font-medium leading-[1.07] profile-description">Content Creator</span>
	                  </article>
	                </div>
	                <p className="text-[14px] text-[#696969]">
	                  {/* Different dummy texts can be placed here for each card */}
	                  Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
	                  Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took 
	                  Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
	                  Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took
	                </p>
	              </div>
	            ))}
	          </div>
	        </div>
	    </section>
		</>
		);
}