	import Link from 'next/link'
	export default function CommerceAccountForm(){
		return(
			<>
			<section className="commerce-account-form pb-[90px]">
			  <div className="container mx-auto px-4">
			    <div className="form-holder max-w-[1124px] mx-auto bg-white max-l:p-[40px] py-[70px] px-[80px] rounded-[22px] text-center relative">
			      <h5 className="max-xl:text-[20px] llg:text-3xl font-nunito font-bold text-[#323232] leading-[1.20] mb-[30px]">Log in Or Sign up Below</h5>

			      <div className="sigup-buttons flex flex-wrap justify-center items-center gap-[25px]">
			        {/* Google */}
			        <div className="sigup-button w-[149px] h-[149px] flex flex-col items-center p-4 border border-[#d0d0d0] rounded-[10px] hover:shadow transition">
			          <Link href="#" className="w-full h-full flex flex-col items-center justify-center">
			            <img src="/images/google-signup.svg" alt="google icon" className="w-12 h-12 mb-[10px]" />
			            <span className="text-xs text-[#888]">Continue with</span>
			            <h6 className="text-xl font-bold">Google</h6>
			          </Link>
			        </div>

			        {/* Facebook */}
			        <div className="sigup-button w-[149px] h-[149px] flex flex-col items-center p-4 border border-[#d0d0d0] rounded-[10px] hover:shadow transition">
			          <Link href="#" className="w-full h-full flex flex-col items-center justify-center">
			            <img src="/images/facebook-signup.svg" alt="facebook icon" className="w-12 h-12 mb-[10px]" />
			            <span className="text-xs text-[#888]">Continue with</span>
			            <h6 className="text-xl font-bold">Facebook</h6>
			          </Link>
			        </div>

			        {/* Apple */}
			        <div className="sigup-button w-[149px] h-[149px] flex flex-col items-center p-4 border border-[#d0d0d0] rounded-[10px] hover:shadow transition">
			          <Link href="#" className="w-full h-full flex flex-col items-center justify-center">
			            <img src="/images/apple-signup.svg" alt="Apple icon" className="w-12 h-12 mb-[10px]" />
			            <span className="text-xs text-[#888]">Sign in with</span>
			            <h6 className="text-xl font-bold">Apple</h6>
			          </Link>
			        </div>
			      </div>

			      <div className="text-center mt-4">
			        <Link href="#" className="email-login text-base text-[#713fff] font-medium underline">
			          Continue with email
			        </Link>
			      </div>
			    </div>

			    <div className="are-you-busiess text-center mt-[55px]">
			      <h3 className="max-md:text-[32px] max-xl:text-[36px] llg:text-[44px] font-bold font-nunito text-[#323232]">Are you a business?</h3>
			      <p className="max-md:text-[15px] max-l:text-base max-xxl:text-[17px] text-lg text-[#323232] font-normal">Set up your business account on YourReview for free</p>
			      <div className="action flex j flex-wrap justify-center gap-6 mt-[30px]">
			        <Link
			          href="/business-registration-login"
			          className="primary-solid max-l:text-sm text-[15px] !min-w-[165px] btn-sm inline-block !py-[12px] !px-[30px] bg-[#713fff] text-white font-medium rounded-[49px] hover:bg-[#713fffcc]"
			        >
			          Login
			        </Link>
			        <Link
			          href="/business-registration-login"
			          className="primary-border max-l:text-sm text-[15px] !min-w-[165px] btn-sm inline-block !py-[12px] !px-[30px] 
			          !border !border-[#713fff] text-[#713fff] font-medium rounded-[49px] hover:bg-[#713fff] hover:text-white"
			        >
			          Sign Up
			        </Link>
			      </div>
			    </div>
			  </div>
			</section>
			</>
			);
	}