'use client';

import React, { useState } from 'react';
import Select, { SingleValue, StylesConfig } from 'react-select';
import Image from 'next/image';
import Link from 'next/link';
import { AnimatePresence, motion } from 'framer-motion';

const businessData = [
  {
    id: 1,
    name: "The Nookmall",
    location: "Irvine, United States",
    logo: "/images/nookmall-logo.png",
    reviews: 1924,
  score: 5.0,
  },
  {
    id: 2,
    name: "The Impound - Secure Star Citizen Store",
    location: "Irvine, United States",
    logo: "/images/the-impound-logo.png",
    reviews: 1924,
  score: 5.0,
  },
  {
    id: 3,
    name: "VirtualMarriage",
    location: "Irvine, United States",
    logo: "/images/virtual-marriage-logo .png",
    reviews: 1924,
  score: 5.0,
  },
  {
    id: 4,
    name: "Oxy Shop",
    location: "Irvine, United States",
    logo: "/images/oxy-shop-logo.png",
    reviews: 1924,
  score: 5.0,
  },
  {
    id: 5,
    name: "LoveBook",
    location: "Irvine, United States",
    logo: "/images/love-book-logo.png",
    reviews: 1924,
  score: 5.0,
  }
];

interface OptionType {
      value: string;
      label: string;
  }

  const releventOptions: OptionType[] = [
      { value: 'Most relevant', label: 'Most relevant' },
      { value: 'Most relevant', label: 'Most relevant' },
  ];

  const customStyles: StylesConfig<OptionType, false> = {
      option: (base, state) => ({
        ...base,
        backgroundColor: state.isSelected
        ? '#f3f3f3'
        : state.isFocused
        ? '#f6f6f6'
        : 'white',
        color: '#343434',
        padding: 10,
        cursor: 'pointer',
        fontSize: '14px',
        fontWeight: state.isSelected ? '700' : '400',
    }),
      control: (base, state) => ({
        ...base,
        width: '100%',
        color: '#343434',
        fontWeight: 700,
        fontSize: 16,
        padding: 0,
        border: '0px solid #e8e8e8',
        borderRadius: 0,
        backgroundColor: 'transparent',
        boxShadow: state.isFocused ? '0 0 0 0px #e8e8e8' : 'none',
        '&:hover': {
          borderColor: 'transparent',
      },
  }),
      singleValue: (base) => ({
        ...base,
        maxWidth: '100%',
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        color: '#343434',
        marginLeft: 0,
        padding: 0,
        fontWeight: 700,
    }),
      placeholder: (base) => ({
        ...base,
        display: 'none', // Hides the placeholder (heading-like text)
    }),
      dropdownIndicator: (base, state) => ({
        ...base,
        padding: 0,
        color: '#999',
        transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
        transition: 'transform 0.2s ease',
        svg: {
          fill: '#999',
          stroke: '#999',
          strokeWidth: 0,
      },
  }),
      indicatorSeparator: () => ({
        display: 'none',
    }),
  };


export default function RightListing() {
  const [selectedOptions, setSelectedOptions] = useState<OptionType>(releventOptions[0]);
  const handleOptionsChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedOptions(option);
};

  const [openIndexes, setOpenIndexes] = useState<number[]>([])

  const toggleOpen = (index: number) => {
    setOpenIndexes((prev) =>
      prev.includes(index)
        ? prev.filter((i) => i !== index)
        : [...prev, index]
    )
  }

  return (
    <>
    <div className="business--listing-header flex justify-between items-center mb-[14px]">
        <span className="result text-[#6b6b6b] text-base font-normal"><b className="text-[#343434] font-bold">1-20 of 7,859</b> results</span>
        <div className="sort flex items-center gap-0">
            <span className="text-[#6a6a6a] text-sm font-normal leading-[1.07]">Sort by :</span>
            <Select
                options={releventOptions}
                value={selectedOptions}
                onChange={handleOptionsChange}
                classNamePrefix="react-select"
                styles={customStyles}
            />
        </div>
    </div>

    <div>
      {businessData.map((business, index) => {
        const isOpen = openIndexes.includes(index)

        return (
          <div key={business.id} className="business--list-card max-l:p-[25px] py-[35px] px-[40px] rounded-[20px] bg-white mb-[18px]">
    <div className="business-card-header flex max-md:flex-col justify-between gap-[30px] mb-[26px]">
        <div className="business-details flex max-md:gap-[15px] gap-[30px] max-md:w-full w-[62%]">
            <a className="details-link" href="/business-detail">
               <Image 
                  className="card-image max-md:w-[70px] max-md:h-[70px] max-l:w-[85px] max-l:h-[85px]" 
                  src={business.logo} alt="Logo"
                  width={105} 
                  height={105} 
              />
          </a>
          <div className="business-name">
            <a className="details-link" href="/business-detail">
                <h5 className="max-l:mb-[8px] max-md:mb-[4px] mb-[10px] max-md:text-[17px] max-l:text-[18px] text-xl font-bold 
                  leading-[1.07]">{business.name}</h5>
            </a>
            <span className="location text-[#737373] flex items-center max-md:mb-[8px] max-l:mb-[10px] mb-[18px] 
                gap-[3px] max-md:text-[13px] max-l:text-sm text-base font-normal leading-[1.07]">
                <i className="icon-location text-base max-l:text-[13px]"></i>{business.location}
            </span>
            <div className="review-actions flex max-md:flex-col max-md:gap-[5px]">
                <div className="star-icons flex">
                    <ul className="flex items-center max-md:p-[4px_7px_4px_0px] gap-[2px] w-auto mr-[20px] rounded-[50px] leading-[0px]">
                        <li><img className="star-rating-icon h-[17px]" src="images/rating-star-full.svg" alt=""/></li>
                        <li><img className="star-rating-icon h-[17px]" src="images/rating-star-full.svg" alt=""/></li>
                        <li><img className="star-rating-icon h-[17px]" src="images/rating-star-full.svg" alt=""/></li>
                        <li><img className="star-rating-icon h-[17px]" src="images/rating-star-half.svg" alt=""/></li>
                        <li><img className="star-rating-icon h-[17px]" src="images/rating-star-blank.svg" alt=""/></li>
                    </ul>
                </div>
                <div className="quick-action flex flex-wrap gap-[9px] ">
                    <a href="/#" className="w-[31px] h-[31px] leading-[31px] text-center inline-block text-[#a19ab9]
                       border border-[#a19ab9] rounded-[4px] font-semibold hover:border-[#713fff] hover:text-[#713fff]">
                       <i className="icon-attach"></i>
                   </a>
                   <a href="/#" className="w-[31px] h-[31px] leading-[31px] text-center inline-block text-[#a19ab9]
                       border border-[#a19ab9] rounded-[4px] font-semibold hover:border-[#713fff] hover:text-[#713fff]"><i className="icon-location"></i></a>
                       <a href="/#" className="w-[31px] h-[31px] leading-[31px] text-center inline-block text-[#a19ab9]
                           border border-[#a19ab9] rounded-[4px] font-semibold hover:border-[#713fff] hover:text-[#713fff]"><i className="icon-envelope-open-o"></i></a>
                       </div>
                   </div>
               </div>
           </div>
           <div className="business-review-details flex flex-col justify-end">
            <label className="block max-md:ml-0 max-md:mr-auto ml-auto max-l:mb-[15px] mb-[27px] max-l:h-[24px] h-[27px] px-[13px] 
                rounded-[17px] border-[2px] border-[#713fff]
                text-[#713fff] max-l:text-[11px] text-[12px] font-bold max-l:leading-[21px] leading-[26px]">MOST RELEVANT</label>
                <div className="reviews flex items-center max-l:gap-[15px] gap-[30px]">
                    <h6 className="text-[#737373] max-l:text-[14px] text-base font-normal leading-[1.07]">
                       YourReview Score
                       <span className="block mt-[2px] max-l:text-[24px] text-[32px] text-[#343434] font-normal leading-[1.07]">
                          {business.score.toFixed(1)}</span>
                      </h6>
                      <div className="break h-[48px] w-[1px] bg-[#d1cddf]"></div>
                      <h6 className="text-[#737373] max-l:text-[14px] text-base font-normal leading-[1.07]">
                       Reviews
                       <span className="block mt-[2px] max-l:text-[24px] text-[32px] text-[#343434] font-normal leading-[1.07]">
                          {business.reviews.toLocaleString()}</span>
                      </h6>
                  </div>
              </div>
          </div>
          <div
              className={`review-toggler flex justify-end relative mb-[-17px] overflow-hidden ${
                isOpen ? 'active' : ''
            }`}
        >
          <button
            onClick={() => toggleOpen(index)}
            className={`toogle-button flex items-center h-[36px] pr-[15px] pl-[20px]
              rounded-[20px] border border-[#d1cddf] text-[#6a6a6a] text-[14px] font-normal
              leading-[35px] relative z-[10] transition-all duration-300 ${
                isOpen
                ? 'bg-[#f1f1f1] rounded-t-[20px] border-[#f1f1f1] active'
                : 'bg-white'
            }`}
        >
            Latest Review

            {/* Arrow container to avoid shifting */}
            <span className="relative w-[16px] h-[16px] ml-[8px] inline-block">
              {/* Down Arrow */}
              <i
                className={`icon-arrow-down2 absolute top-0 left-0 w-full h-full text-[#9e96b2] text-[14px] leading-[0px] transition-opacity duration-200 ${
                  isOpen ? 'rotate-180 opacity-0' : 'opacity-100'
              }`}
          ></i>

              {/* Up Arrow */}
              <i
                className={`icon-arrow-up2 absolute top-0 left-0 w-full h-full text-[#9e96b2] text-[14px] leading-[0px] transition-opacity duration-200 ${
                  isOpen ? 'opacity-100 rotate-0' : 'opacity-0'
              }`}
          ></i>
          </span>
      </button>
  </div>
  <AnimatePresence initial={false}>
     {isOpen && (
        <motion.div
            key="toggle-content"
            initial={{ opacity: 0, y: -10 }}
            animate={{ opacity: 1, y: 0 }}
            exit={{ opacity: 0, y: -10 }}
            transition={{ duration: 0.5 }}
            className="busines-latest-review"
        >
            <div className="card-container max-mmd:py-[24px] max-mmd:px-[15px] flex max-xxl:flex-col gap-[20px] py-[28px] 
               px-[26px] rounded-[16px] bg-[#f1f1f1]">
               <div className="review-card max-mmd:py-[24px] max-mmd:px-[15px] py-[24px] px-[26px] rounded-[20px] bg-[#ffffff]">
                <div className="card-user-header flex max-md:flex-col max-md:items-start max-md:gap-[8px] items-center gap-[19px] mb-[18px]">
                    <Image 
                       className="prifile-image w-[42px] h-[42px] rounded-full" 
                       src="/images/user-1.png" alt="User"
                       width={47}
                       height={47}
                   />
                   <div className="user-star">
                    <div className="user-details flex max-sm:flex-col gap-[4px]">
                        <h6 className="text-[#000000] text-sm font-bold leading-[1.20]">Gabi Guerra</h6>
                        <span className="reviewed text-[#767676] text-sm font-normal leading-[1.20]">
                           reviewed</span>
                           <span className="post text-[#2e2e2e] text-sm font-semibold leading-[1.20] underline">
                               Post Lake Lending</span>
                           </div>
                           <div className="star-icons flex mt-[7px]">
                            <ul className="flex items-center gap-[2px] w-auto mr-[20px] rounded-[50px] leading-0">
                                <li><img className="star-rating-icon" src="images/rating-star-full.svg" alt=""/></li>
                                <li><img className="star-rating-icon" src="images/rating-star-full.svg" alt=""/></li>
                                <li><img className="star-rating-icon" src="images/rating-star-full.svg" alt=""/></li>
                                <li><img className="star-rating-icon" src="images/rating-star-half.svg" alt=""/></li>
                                <li><img className="star-rating-icon" src="images/rating-star-blank.svg" alt=""/></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <p className="text-[#696969] text-sm font-normal leading-[1.47]" >Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
                    Ipsum has been the industry's standard dummy text ever since the 1500s, when an
                    unknown printer took</p>
                </div>
                <div className="review-card py-[24px] px-[26px] rounded-[20px] bg-[#ffffff]">
                    <div className="card-user-header flex items-center gap-[19px] mb-[18px]">
                        <Image 
                           className="prifile-image w-[42] h-[42] rounded-full" 
                           src="/images/user-2.png" alt="User"
                           width={47}
                           height={47}
                       />
                       <div className="user-star">
                        <div className="user-details flex gap-[4px]">
                            <h6 className="text-[#000000] text-sm font-bold leading-[1.20]">Gabi Guerra</h6>
                            <span className="reviewed text-[#767676] text-sm font-normal leading-[1.20]">
                               reviewed</span>
                               <span className="post text-[#2e2e2e] text-sm font-semibold leading-[1.20] underline">
                                   Post Lake Lending</span>
                               </div>
                               <div className="star-icons flex mt-[7px]">
                                <ul className="flex items-center gap-[2px] w-auto mr-[20px] rounded-[50px] leading-0">
                                    <li><img className="star-rating-icon" src="images/rating-star-full.svg" alt=""/></li>
                                    <li><img className="star-rating-icon" src="images/rating-star-full.svg" alt=""/></li>
                                    <li><img className="star-rating-icon" src="images/rating-star-full.svg" alt=""/></li>
                                    <li><img className="star-rating-icon" src="images/rating-star-half.svg" alt=""/></li>
                                    <li><img className="star-rating-icon" src="images/rating-star-blank.svg" alt=""/></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <p className="text-[#696969] text-sm font-normal leading-[1.47]" >Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
                        Ipsum has been the industry's standard dummy text ever since the 1500s, when an
                        unknown printer took</p>
                    </div>
                </div>
            </motion.div>
            )}
</AnimatePresence>
<div className="review-links flex max-l:flex-col flex-wrap gap-y-[10px] gap-x-[30px] mt-[24px]">
    <a href="/#" className="text-[#737373] text-sm font-normal leading-[1.07] relative hover:text-[#713fff]">Video Game Store</a>
    <a href="/#" className="text-[#737373] text-sm font-normal leading-[1.07] relative hover:text-[#713fff]">Game Store</a>
    <a href="/#" className="text-[#737373] text-sm font-normal leading-[1.07] relative hover:text-[#713fff]">Video Game Rental Store</a>
    <a href="/#" className="text-[#737373] text-sm font-normal leading-[1.07] relative hover:text-[#713fff]">Used Game Store</a>
</div>
</div>
        );
      })}
    </div>

    <div className="pagination flex justify-between items-center m-0 pt-[48px]">
        <Link href="/#" className="prev max-md:text-[4px] text-[8px]
         rounded-[100px] max-md:leading-[34px] leading-[43px] max-md:w-[50px] w-[93px] max-md:h-[34px] h-[43px]
         border border-[#a5b4bc] text-[#a5b4bc] inline-block text-center hover:text-[#713fff] hover:border-[#713fff]">
         <i className="icon-arrow-long-left2">
         </i></Link>
         <ul className="flex justify-center items-center gap-y-[3px] gap-x-[5px]">
          <li><Link className="active flex justify-center items-center 
            text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">1</Link></li>
            <li><Link className="flex justify-center items-center 
              text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">2</Link></li>
              <li><Link className="flex justify-center items-center 
                text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">3</Link></li>
                <li><Link className="flex justify-center items-center 
                  text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">4</Link></li>
                  <li><Link className="flex justify-center items-center 
                    text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">5</Link></li>
                    <li><Link className="flex justify-center items-center 
                      text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">...</Link></li>
                      <li><Link className="flex justify-center items-center 
                        text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">25</Link></li>
                      </ul>
                      <Link href="/#" className="next max-md:text-[4px] text-[8px]
                       rounded-[100px] max-md:leading-[34px] leading-[43px] max-md:w-[50px] w-[93px] max-md:h-[34px] h-[43px]
                       border border-[#a5b4bc] text-[#a5b4bc] inline-block text-center hover:text-[#713fff] hover:border-[#713fff]">
                       <i className="icon-arrow-long-right2"></i></Link>
                     </div>
    </>
  )
}
