'use client';

import { useState } from 'react';

export default function RatingSlider() {
  const [value, setValue] = useState(0);

  const labels = ['Any', '3.0+', '4.0+', '4.5+'];

  return (
    <div className="custom-rang-slider-container">
      <h5 className="max-md:text-[17px] max-l:text-[18px] text-[20px] mb-[16px] font-bold leading-[1.07] text-[#323232]">
        Rating
      </h5>

      <div className="custom-rang-slider-labels flex justify-between mt-[10px]">
        {labels.map((label, index) => (
          <span
            key={index}
            className={`text-[14px] text-[#716f76] font-bold px-[7px] 
            relative relative ${value === index ? 'text-[#8a2be2] selected' : ''}`}
          >
            {label}
          </span>
        )).reduce((acc, curr, idx) => {
          // Add separator <i> between spans
          if (idx < labels.length - 1) {
            acc.push(curr);
            acc.push(<i key={`sep-${idx}`} className="inline-block w-[1px] h-[17px] bg-[#d1cddf] mx-[2px] align-middle" />);
          } else {
            acc.push(curr);
          }
          return acc;
        }, [] as React.ReactNode[])}
      </div>

      <input
        type="range"
        min="0"
        max="3"
        step="1"
        value={value}
        onChange={(e) => setValue(Number(e.target.value))}
        className="custom-slider cursor-pointer z-10" id="custom-rang-slider"
        style={{
          WebkitAppearance: 'none',
          appearance: 'none',
          outline: 'none',
          background: 'transparent'
        }}
      />
    </div>
  );
}
