'use client';

import React, { useState } from 'react';
import Select, { SingleValue, StylesConfig } from 'react-select';
import RatingSlider from './RatingSlider';
import Link from 'next/link'

interface OptionType {
  value: string;
  label: string;
}

const countryOptions: OptionType[] = [
  { value: '', label: 'Country' },
  { value: 'us', label: 'United States' },
  { value: 'uk', label: 'United Kingdom' },
];

const customStyles: StylesConfig<OptionType, false> = {
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected
      ? '#f3f3f3'
      : state.isFocused
      ? '#f6f6f6'
      : 'white',
    color: '#969696',
    padding: 10,
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: state.isSelected ? '700' : '400',
  }),
  control: (base, state) => ({
    ...base,
    width: '100%',
    color: '#969696',
    fontWeight: 400,
    fontSize: 16,
    padding: '4px',
    border: '1px solid #e8e8e8',
    borderRadius: 5,
    backgroundColor: 'white',
    boxShadow: state.isFocused ? '0 0 0 1px #e8e8e8' : 'none',
    '&:hover': {
      borderColor: '#e8e8e8',
    },
  }),
  singleValue: (base) => ({
    ...base,
    maxWidth: '100%',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    color: '#969696',
    marginLeft: '2px',
    marginRight: '2px',
    fontWeight: 400,
  }),
  dropdownIndicator: (base) => ({
    ...base,
    color: '#999',
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
};

export default function LeftFilter() {
  const [selectedCountry, setSelectedCountry] = useState<OptionType>(countryOptions[0]);

  const handleCountryChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedCountry(option);
  };

  return (
    <>

    {/*Rating Location Box*/}
    <div className="side-box max-l:p-[30px] p-[37px] mb-[32px] bg-[#e4e8ef] rounded-[20px]">
      <div className="rating-slider mb-[30px]">
        <RatingSlider />
      </div>

      <h5 className="max-md:text-[17px] max-l:text-[18px] mb-[16px] font-bold leading-[1.07] text-[#323232]">Location</h5>

      <form>
        <Select
          options={countryOptions}
          value={selectedCountry}
          onChange={handleCountryChange}
          classNamePrefix="react-select"
          placeholder="Country"
          styles={customStyles}
        />

        <div className="form-field mt-2 relative">
          <input type="text" className="w-full px-[15px] rounded-[4px] h-[45px] 
            text-[#969696] text-base font-normal leading-[45px] focus:outline-none focus:ring-0 focus:border-transparent " />
          <i className="icon-search absolute right-4 top-1/2 -translate-y-1/2 text-base text-[#969696]"></i>
        </div>
      </form>
    </div>

    {/*Company Status Box*/}

    <div className="side-box max-l:p-[30px] p-[37px] mb-[32px] bg-[#e4e8ef] rounded-[20px]">
      <h5 className="max-md:text-[17px] max-l:text-[18px] text-[20px] mb-[16px] font-bold leading-[1.07] text-[#323232]">Company status</h5>
      <div className="custom-check-tick">
          <input id="verified" className="checkbox-custom cursor-pointer relative hidden"  type="checkbox" />
          <label htmlFor="verified" className="checkbox-custom-label cursor-pointer 
            relative text-[#737373] w-full mb-[14px] pb-[13px] border-b border-[#d1cddf] inline-block">
            Verified</label>
      </div>
      <div className="custom-check-tick">
          <input id="claimed" className="checkbox-custom hidden" type="checkbox" />
          <label htmlFor="claimed" className="checkbox-custom-label cursor-pointer 
            relative text-[#737373] w-full mb-[14px] pb-[13px] border-b border-[#d1cddf] inline-block">Claimed</label>
      </div>
    </div>

    {/*Subcategories Box*/}

    <div className="side-box max-l:p-[30px] p-[37px] mb-[32px] bg-[#e4e8ef] rounded-[20px]">
      <h5 className="max-md:text-[17px] max-l:text-[18px] text-[20px] mb-[16px] font-bold leading-[1.07] text-[#323232]">Subcategories</h5>
      <div className="flex flex-wrap max-xl:gap-[5px]">
      <div className="custom-check-selection inline">
          <input id="adult-entertainment" className="checkbox-custom text-[#713fff] hidden opacity-0" type="checkbox" />
          <label htmlFor="adult-entertainment" className="checkbox-custom-label
           text-[#7d7595] border border-[#cecadc] inline-block py-[7px] px-[13px] mb-[5px] h-auto 
           rounded-[18px] text-sm font-normal leading-[18px] cursor-pointer">
            Adult Entertainment</label>
      </div>
      <div className="custom-check-selection inline">
          <input id="children-entertainment" className="checkbox-custom text-[#713fff] hidden opacity-0" type="checkbox" />
          <label htmlFor="children-entertainment" className="checkbox-custom-label
           text-[#7d7595] border border-[#cecadc] inline-block py-[7px] px-[13px] mb-[5px] h-auto 
           rounded-[18px] text-sm font-normal leading-[18px] cursor-pointer">Children's
              Entertainment</label>
      </div>
      <div className="custom-check-selection">
          <input id="clubbing-nightlife" className="checkbox-custom text-[#713fff] hidden opacity-0" type="checkbox" />
          <label htmlFor="clubbing-nightlife" className="checkbox-custom-label
           text-[#7d7595] border border-[#cecadc] inline-block py-[7px] px-[13px] mb-[5px] h-auto 
           rounded-[18px] text-sm font-normal leading-[18px] cursor-pointer">Clubbing & Nightlife</label>
      </div>
      <div className="custom-check-selection">
          <input id="gambling" className="checkbox-custom text-[#713fff] hidden opacity-0" type="checkbox" />
          <label htmlFor="gambling" className="checkbox-custom-label
           text-[#7d7595] border border-[#cecadc] inline-block py-[7px] px-[13px] mb-[5px] h-auto 
           rounded-[18px] text-sm font-normal leading-[18px] cursor-pointer">Gambling</label>
      </div>
      </div>
        <div className="cta mt-[22px] pt-[17px] border-t border-[#d1cddf]">
          <Link href="/#" className="flex justify-between items-center w-full ">
          <span className="text-[#7d7595] text-sm font-bold leading-[1.07] underline">Show all</span> 
          <i className="icon-arrow-down2 text-[#7d7595] text-sm font-bold leading-[1.07]"></i></Link>
      </div>
    </div>
    </>
  );
}
