import Link from 'next/link'
export default function InnerBanner(){
	return(
		<>
		<section className="inner-banner business-list-bnner text-center pt-[140px] pb-[57px]">
			<div className="container mx-auto px-4 text-center">
				<div className="container--wraper">

					<h1 className="font-extrabold max-sm:max-w-[320px] max-xl:text-[54px] max-sm:text-[36px] leading-[1.08] mx-auto">
						Best in Events & Entertainment
					</h1>
					<p className="text-[#343434] text-center font-inter text-xl font-semibold leading-[147%] mt-[15px]">
						Compare the best companies in this category
					</p>

					<form action="/#" name="search-form">
						<div className="site-search flex flex-col justify-center items-center gap-4 !mt-[42px]">
							<input
								type="text"
								placeholder="Search a Business or product Name"
								className="form-control w-full max-md:!text-[14px] max-md:!leading-[55px] max-md:!px-[20px] py-2 border border-gray-300 rounded-md focus:outline-none 
								focus:ring-2 focus:ring-blue-500"
							/>
							<Link href="/business-listing" className="absolute right-[13px] top-1/2 -translate-y-1/2 
								flex items-center justify-center gap-x-1.5 rounded-full bg-[#713fff] 
								text-white font-bold backdrop-blur-sm w-12 h-12 p-0 min-w-0 md:w-auto 
								md:h-auto md:px-[27px] md:leading-[43px] md:min-w-[130px] md:text-[14px] hover:bg-[#323232]" > 
								<svg xmlns="http://www.w3.org/2000/svg" className="w-5 h-5 text-white" fill="none" 
									viewBox="0 0 24 24" stroke="currentColor" strokeWidth="2" > <path strokeLinecap="round" 
										strokeLinejoin="round" d="M21 21l-4.35-4.35M17 10.5A6.5 6.5 0 104 10.5a6.5 6.5 0 0013 0z" /> 
									</svg> 
									<span className="hidden md:inline">Search</span> 
								</Link>

						</div>
					</form>
				</div>
			</div>
		</section>
		</>
		);
}