  import Image from 'next/image'
  import Link from 'next/link'

  export default function ReviewsCard() {
    const reviews = [
      {
        id: 1,
        name: "Gabi Guerra",
        profileImage: "/images/profile-image-1.jpg",
        reviewCount: "1 review",
        stars: [1, 1, 1, 0.5, 0],
        location: "United States",
        timeAgo: "10 hours ago",
        verified: true,
        body: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
      Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. 
      Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
        Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took`,
        experienceDate: "February 07, 2024",
      },
      {
        id: 2,
        name: "Alex Johnson",
        profileImage: "/images/profile-image-2.jpg",
        reviewCount: "3 reviews",
        stars: [1, 1, 1, 1, 0],
        location: "Canada",
        timeAgo: "2 days ago",
        verified: true,
        body: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
      Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. 
      Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
        Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took`,
        experienceDate: "March 21, 2024",
      },
      {
        id: 3,
        name: "Alex Johnson",
        profileImage: "/images/profile-image-2.jpg",
        reviewCount: "3 reviews",
        stars: [1, 1, 1, 1, 0],
        location: "Canada",
        timeAgo: "2 days ago",
        verified: true,
        body: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
      Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. 
      Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
        Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took`,
        experienceDate: "March 21, 2024",
      },
      {
        id: 4,
        name: "Alex Johnson",
        profileImage: "/images/profile-image-2.jpg",
        reviewCount: "3 reviews",
        stars: [1, 1, 1, 1, 0],
        location: "Canada",
        timeAgo: "2 days ago",
        verified: true,
        body: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
      Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. 
      Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
        Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took`,
        experienceDate: "March 21, 2024",
      },
      {
        id: 5,
        name: "Alex Johnson",
        profileImage: "/images/profile-image-2.jpg",
        reviewCount: "3 reviews",
        stars: [1, 1, 1, 1, 0],
        location: "Canada",
        timeAgo: "2 days ago",
        verified: true,
        body: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
      Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. 
      Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
        Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took`,
        experienceDate: "March 21, 2024",
      },
    ];


    return (
      <>
      <div className="reviews-card-holder flex flex-col gap-[14px]">
        {reviews.map((review) => (
          <div className="reviews-card max-md:p-[25px] p-10 rounded-[20px] bg-white" key={review.id}>
            <div className="reviews-card--heading flex max-md:flex-col max-md:gap-y-[10px]  justify-between pl-[60px] mb-[18px] relative">
              <Image className="profile-image w-[43px] h-[43px] object-cover object-center rounded-[50%] absolute left-0" 
               src={review.profileImage} alt={review.name} 
               width={100}
               height={100}
             />
             <div className="profile-details">
              <h6 className="text-[#000] text-sm font-bold leading-[1.20] mb-[7px]">
                {review.name} <span className="review-count text-[#767676] font-normal text-sm leading-[1.20] pl-[5px] mb-[7px]">
                  {review.reviewCount}
                </span>
              </h6>
              <div className="location-rating flex gap-[10px] items-center">
                <div className="star-icons flex">
                  <ul className="mr-0 flex items-center gap-[2px] w-auto max-md:p-[4px_7px_4px_0px] p-0 rounded-[50px] leading-0">
                    {review.stars.map((star, index) => {
                      let starIcon = "rating-star-blank.svg";
                      if (star === 1) starIcon = "rating-star-full.svg";
                      else if (star === 0.5) starIcon = "rating-star-half.svg";
                      return (
                        <li key={index} className="leading-0">
                          <img className="star-rating-icon h-[17px]" src={`images/${starIcon}`} alt="" />
                        </li>
                        );
                    })}
                  </ul>
                </div>
                <span className="location text-[#737373] text-sm font-normal leading-[1.07]">
                  <i className="icon-location text-[16px]"></i> {review.location}
                </span>
              </div>
            </div>
            <div className="review-time flex items-center max-md:gap-[10px] gap-[20px]">
              <span className="post-time text-[#737373] text-sm font-normal leading-[1.07]">{review.timeAgo}</span>
              {review.verified && <span className="verified-label">Verified</span>}
            </div>
          </div>

          <div className="reviews-card--body mb-[18px]">
            <p className="text-[#696969] text-sm font-normal leading-[1.47]">{review.body}</p>
          </div>

          <div className="reviews-card--footer flex max-md:flex-col max-md:items-start max-md:gap-[15px] 
            justify-between items-center">
            <span className="share-review text-[#6a6a6a] text-sm font-normal leading-[1.07]">
              Date of experience: <strong className="text-[#343434] font-bold">{review.experienceDate}</strong>
            </span>
            <div className="quick-action flex flex-wrap gap-[9px]">
              <Link href="/#" className="h-[31px] w-[31px] leading-[31px] text-center inline-block
                text-[#a19ab9] border border-[#a19ab9] rounded-[4px] font-semibold">
                <i className="icon-like"></i>
              </Link>
              <Link href="/#" className="h-[31px] w-[31px] leading-[31px] text-center inline-block
                text-[#a19ab9] border border-[#a19ab9] rounded-[4px] font-semibold">
                <i className="icon-share"></i>
              </Link>
              <Link href="/#" className="h-[31px] w-[31px] leading-[31px] text-center inline-block
                text-[#a19ab9] border border-[#a19ab9] rounded-[4px] font-semibold">
                <i className="icon-flag"></i>
              </Link>
            </div>
          </div>
        </div>
        ))}
      </div>
      <div className="pagination flex justify-between items-center m-0 pt-[48px]">
        <Link href="/#" className="prev max-md:text-[4px] text-[8px]
         rounded-[100px] max-md:leading-[34px] leading-[43px] max-md:w-[50px] w-[93px] max-md:h-[34px] h-[43px]
         border border-[#a5b4bc] text-[#a5b4bc] inline-block text-center hover:text-[#713fff] hover:border-[#713fff]">
         <i className="icon-arrow-long-left2">
         </i></Link>
         <ul className="flex justify-center items-center gap-y-[3px] gap-x-[5px]">
          <li><Link className="active flex justify-center items-center 
            text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">1</Link></li>
            <li><Link className="flex justify-center items-center 
              text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">2</Link></li>
              <li><Link className="flex justify-center items-center 
                text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">3</Link></li>
                <li><Link className="flex justify-center items-center 
                  text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">4</Link></li>
                  <li><Link className="flex justify-center items-center 
                    text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">5</Link></li>
                    <li><Link className="flex justify-center items-center 
                      text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">...</Link></li>
                      <li><Link className="flex justify-center items-center 
                        text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">25</Link></li>
                      </ul>
                      <Link href="/#" className="next max-md:text-[4px] text-[8px]
                       rounded-[100px] max-md:leading-[34px] leading-[43px] max-md:w-[50px] w-[93px] max-md:h-[34px] h-[43px]
                       border border-[#a5b4bc] text-[#a5b4bc] inline-block text-center hover:text-[#713fff] hover:border-[#713fff]">
                       <i className="icon-arrow-long-right2"></i></Link>
                     </div>
                     </>
                     );
}
