import Image from 'next/image'
import RatingProgressBar from './RatingProgressBar'


const ratingsData = [
  { stars: 5, percent: 89 },
  { stars: 4, percent: 40 },
  { stars: 3, percent: 25 },
  { stars: 2, percent: 30 },
  { stars: 1, percent: 15 },
];

export default function RatingOverview(){
	return(
		<>
		<div className="rating-overview flex max-md:flex-col max-md:gap-y-[25px] max-md:p-[25px] p-[45px_35px_60px_35px] border border-[#efedf5] bg-white rounded-[20px]">
                    <div className="rating-overview--left max-md:w-full max-xxl:w-[60%] w-1/2">
                        <figure className="flex items-center gap-[16px]">
                            <Image src="/images/profile-image-3.jpg" alt="profile-image-3"
                            	   width={100}
                            	   height={100}
                            	   className="w-[42px] h-[42px] rounded-[50%]"
                            />
                            <figcaption className="text-[#000] text-[15px] font-bold leading-[1.20]">
                            	Gabi Guerra
                            </figcaption>
                        </figure>
                        <p className="text-[#696969] max-w-[305px] text-sm font-normal leading-[1.47]">
                        	Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                        <div className="star-icons flex mt-[15px]">
                            <ul className="flex items-center gap-[2px] w-auto max-md:p-[4px_7px_4px_0px] p-0 mr-[20px] rounded-[50px] leading-0">
                                <li>
                                    <img className="star-rating-icon max-xl:h-[32px] h-[50px]" src="images/rating-star-full.svg" alt=""/>
                                    <span className="star_label block text-[#716f76] text-center text-sm font-bold mt-[11px]">1</span>
                                </li>
                                <li>
                                    <img className="star-rating-icon max-xl:h-[32px] h-[50px]" src="images/rating-star-full.svg" alt=""/>
                                    <span className="star_label block text-[#716f76] text-center text-sm font-bold mt-[11px]">2</span>
                                </li>
                                <li>
                                    <img className="star-rating-icon max-xl:h-[32px] h-[50px]" src="images/rating-star-full.svg" alt=""/>
                                    <span className="star_label block text-[#716f76] text-center text-sm font-bold mt-[11px]">3</span>
                                </li>
                                <li>
                                    <img className="star-rating-icon max-xl:h-[32px] h-[50px]" src="images/rating-star-half.svg" alt=""/>
                                    <span className="star_label block text-[#716f76] text-center text-sm font-bold mt-[11px]">4</span>
                                </li>
                                <li>
                                    <img className="star-rating-icon max-xl:h-[32px] h-[50px]" src="images/rating-star-blank.svg" alt=""/>
                                    <span className="star_label block text-[#716f76] text-center text-sm font-bold mt-[11px]">5</span>
                                </li>
                            </ul>
                        </div>
                        <div className="reviews-count flex items-center gap-[20px] mt-[30px]">
                            <span>
                                <strong className="block mb-[5px] font-bold">Reviews - 4.7</strong>
                                81,909 total
                            </span>
                            <a className="ms-btn primary-border btn-lg max-l:!py-[16px] max-l:!px-[20px]
                             !py-[20px] !px-[30px] max-l:!text-[15px] !text-[18px]" 
                            	href="/#">Write a review</a>
                        </div>
                    </div>

                    {/*RatingProgressBar*/}
                    <RatingProgressBar ratings={ratingsData} />

                </div>
		</>
		);
}