import Link from 'next/link'

export default function ProductOverviewDetails(){
	return(
		<>
		<div className="product-overview--details bg-white rounded-[20px]">
                    <div className="company-activity max-md:p-[25px] p-[35px]">
                       <div className="heading flex justify-between mb-[20px]">
                            <h6 className="text-xl font-bold leading-[1.07]">Company activity</h6>
                            <Link href="/#" className="text-[#7d7595] text-sm font-bold leading-[1.07] underline">
                            	Show all
                            </Link>
                       </div>
                       <ul>
                            <li className="mb-[7px] py-[14px] px-[25px] rounded-[100px] bg-[#f1eef8] text-[#737373]
                             text-sm font-normal leading-[1.17] flex items-center gap-[10px]">
                            	<img src="images/icon_calendar.svg" alt=""
                            		 className="h-[17px] w-[17px] object-contain"
                            	/>
                            	Claimed profile
                            </li>
                            <li className="mb-[7px] py-[14px] px-[25px] rounded-[100px] bg-[#f1eef8] text-[#737373]
                             text-sm font-normal leading-[1.17] flex items-center gap-[10px]">
                             <img src="images/icon_ask.svg" alt=""
                             	  className="h-[17px] w-[17px] object-contain"
                             />
                             Asks for reviews — positive or negative
                         	</li>
                            <li className="mb-[7px] py-[14px] px-[25px] rounded-[100px] bg-[#f1eef8] text-[#737373]
                             text-sm font-normal leading-[1.17] flex items-center gap-[10px]">
                             <img src="images/icon_pay-extra.svg" alt="" 
                             	  className="h-[17px] w-[17px] object-contain"
                             />
                             Pays for extra features
                         	</li>
                            <li className="mb-[7px] py-[14px] px-[25px] rounded-[100px] bg-[#f1eef8] text-[#737373]
                             text-sm font-normal leading-[1.17] flex items-center gap-[10px]">
                             <img src="images/icon_chat.svg" alt=""
                             	  className="h-[17px] w-[17px] object-contain"
                             />
                             Replied to 69% of negative reviews
                         	</li>
                            <li className="mb-[7px] py-[14px] px-[25px] rounded-[100px] bg-[#f1eef8] text-[#737373]
                             text-sm font-normal leading-[1.17] flex items-center gap-[10px]">
                             <img src="images/icon_time.svg" alt=""
                             	  className="h-[17px] w-[17px] object-contain"
                             />
                             Replies to negative reviews in &#60; 2 weeks
                         	</li>
                       </ul>
                    </div>
                    <div className="about-product p-[35px] border-t border-[#e3e0ed]">
                        <div className="heading mb-[16px]">
                            <h6 className="text-xl font-bold leading-[1.07]">About LoveBook</h6>
                            <span className="subline text-[#7c7c7c] text-[12px] font-normal leading-[1.47]">
                                Information written by the company</span>
                        </div>
                        <p className="text-[#696969] text-sm leading-[1.47]">LoveBook™ began as a simple idea—a handmade notebook listing all the reasons why one guy loved his wife. 
                            The gift was a hit, giving birth to the first "LoveBook". 
                            Rob Patterson knew that his wife adored the book, but would anyone else? That's where John Baranowski, 
                            Kevin Zalewski, and Chris Sonjeow came in. They all saw the potential of the present to help people connect 
                            with their loved ones in a meaningful way. Working 9-5 at a manufacturing company, the guys met after work each 
                            night to refine the platform meant for the masses. It wasn't until May 2010, when they were contacted by 
                            The Today Show to be on a gift segment with Kathy Lee and Hoda, that the guys knew this was something special. 
                            After that, the idea blew up. They were able to quit their day jobs and hire two graphic designers. 
                            Fast-forward to 2016, and the company has had major growth, and has hired 9 employees (and growing each year). 
                            What started as a little side gig, LoveBook is now a major contender in the gift category, going up against 
                            flowers and chocolates (to name a few). John, Chris, Rob and Kevin are not quite the Beatles, but this fab 
                            four still believed that all you need is LOVE…and a little determination.</p>
                    </div>
                </div>

                <div className="company-contact--detail bg-white rounded-[20px] p-[35px] mt-[14px]">
                    <h6 className="text-xl font-bold leading-[1.07]">Contact</h6>
                    <ul className="text-sm text-[#696969] font-normal leading-[1.47]">
  {/* Email */}
  <li className="flex items-start gap-3 border-b border-[#e3e0ed]  p-[11px_0px_11px_0px]">
    <span className="icon-envelope-open2 text-[#713fff] text-[18px]"></span>
    <span>help@lovebookonline.com</span>
  </li>

  {/* Phone */}
  <li className="flex items-start gap-3 border-b border-[#e3e0ed]  p-[11px_0px_11px_0px]">
    <span className="icon-phone text-[#713fff] text-[18px]"></span>
    <span>(800) 628-6447</span>
  </li>

  {/* Address */}
  <li className="flex items-start gap-3 p-[11px_0px_11px_0px]">
    <span className="icon-location text-[#713fff] text-[18px]"></span>
    <div className="space-y-1">
      <p className="text-[#696969] text-sm">321 E. 2nd Street</p>
      <p className="text-[#696969] text-sm">48307</p>
      <p className="text-[#696969] text-sm">Rochester</p>
      <p className="text-[#696969] text-sm">United States</p>
    </div>
  </li>
</ul>

                </div>
		</>
		);
}