import Image from 'next/image'

export default function InnerBanner(){
	return(
		<>
		<section className="inner-banner we-believe pt-[140px] text-center">
	      <div className="container mx-auto px-4">
	        <div className="content--wraper relative">
	          <h1 className="max-w-[970px] mx-auto max-md:mb-[60px] max-l:mb-5 mb-[-62px] font-extrabold max-sm:text-4xl max-xl:text-[54px] relative z-[1] leading-[1.08]">
	            We're dedicated to becoming the most reliable review platform globally.
	          </h1>
	            <Image
	              src="/images/banner-map-dots.svg"
	              alt="World Map Dots"
	              width={1296}
	              height={648}
	              className="banner-map-imagew-full max-md:hidden"
	            />

	          <div className="achievements flex max-l:flex-col max-l:gap-y-[25px] max-l:text-center max-l:relative justify-around text-left pb-[58px] absolute w-full bottom-0 z-[1]">
	            <div className="achievements-block">
	              <h3 className="max-md:text-[32px] max-sm:text-[28px] max-xl:text-4xl text-[40px] font-nunito font-bold text-[#323232] leading-[1.20]">+181 million</h3>
	              <p className="max-xl:text-base -lg font-nunito font-bold text-[#6d6d6d] max-l:text-center text-left">Reviews on YourReview</p>
	            </div>
	            <div className="achievements-block">
	              <h3 className="max-md:text-[32px] max-sm:text-[28px] max-xl:text-4xl text-[40px] font-nunito font-bold text-[#323232] leading-[1.20]">+581,000</h3>
	              <p className="max-xl:text-base text-lg font-nunito font-bold text-[#6d6d6d] max-l:text-center text-left">Websites with reviews on YourReview</p>
	            </div>
	            <div className="achievements-block">
	              <h3 className="max-md:text-[32px] max-sm:text-[28px] max-xl:text-4xl text-[40px] font-nunito font-bold text-[#323232] leading-[1.20]">+1.3 million</h3>
	              <p className="max-xl:text-base text-lg font-nunito font-bold text-[#6d6d6d] max-l:text-center text-left">Fake reviews removed in 2021</p>
	            </div>
	          </div>
	        </div>
	      </div>
	    </section>
		</>
		);
}