import Link from 'next/link'

export default function Pagination() {
	return (
		<>
		<section className="pt-[3rem] pb-[80px] bg-[#f5f5f5]">
	        <div className="container mx-auto px-4">
	        <div className="flex items-center justify-between">
	          <Link href="/customer-stories" className="w-[93px] h-[43px] border border-[#713fff] no-underline 
	          flex items-center justify-center text-[12px] rounded-[43px] text-[#713fff] 
	          hover:bg-[#713fff] hover:text-[#ffffff] max-md:w-[55px] max-md:h-[43px] max-md:text-[8px] nav-prev">
	          <span className="icon-arrow-long-left2">
	          </span>
	          </Link>
	          <ul className="flex">
	            {[1, 2, 3, 4, 5, '...', 25].map((num, index) => (
	              <li key={index}>
	                <Link
	                  href="/customer-stories"
	                  className="text-[#323232] text-base font-bold hover:text-[#713fff] !leading-[1.11] p-[10px]
	                  max-md:text-sm max-md:p-[8px]" 
	                >
	                  {num}
	                </Link>
	              </li>
	            ))}
	          </ul>
	          <Link href="/customer-stories" className="w-[93px] h-[43px] border border-[#713fff] no-underline 
	          flex items-center justify-center text-[12px] rounded-[43px] text-[#713fff] 
	          hover:bg-[#713fff] hover:text-[#ffffff] max-md:w-[55px] max-md:h-[43px] max-md:text-[8px] nav-next">
	            <span className="icon-arrow-long-right2">
	            </span>
	          </Link>
	        </div>
	        </div>
	    </section>
		</>
		);
}