'use client';

import { useState, useEffect } from 'react';
import Select from 'react-select';
import Link from 'next/link'

interface ProductProps {
  name: string;
}

const tabOptions = ['Reviews', 'Photos', 'Question & Answer'];

const sortOptions = [
  { value: 'latest', label: 'Latest' },
  { value: 'popular', label: 'Most Popular' },
];

interface Review {
  name: string;
  location: string;
  profileImage: string;
  rating: number;
  review: string;
  date: string;
  views: number;
}

const reviews: Review[] = [
  {
    name: 'Jhone Geo13489',
    location: 'Delhi India',
    profileImage: '/images/profile-image-1.jpg',
    rating: 3.5,
    review:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took",
    date: 'Dec 22, 2021 12:32 PM',
    views: 701,
  },
  {
    name: 'Jhone Geo13489',
    location: 'Delhi India',
    profileImage: '/images/profile-image-1.jpg',
    rating: 3.5,
    review:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took",
    date: 'Dec 22, 2021 12:32 PM',
    views: 701,
  },
  {
    name: 'Jhone Geo13489',
    location: 'Delhi India',
    profileImage: '/images/profile-image-1.jpg',
    rating: 3.5,
    review:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took",
    date: 'Dec 22, 2021 12:32 PM',
    views: 701,
  },
  {
    name: 'Jhone Geo13489',
    location: 'Delhi India',
    profileImage: '/images/profile-image-1.jpg',
    rating: 3.5,
    review:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took",
    date: 'Dec 22, 2021 12:32 PM',
    views: 701,
  },
  {
    name: 'Jhone Geo13489',
    location: 'Delhi India',
    profileImage: '/images/profile-image-1.jpg',
    rating: 3.5,
    review:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took",
    date: 'Dec 22, 2021 12:32 PM',
    views: 701,
  },
];

const customStyles = {
  control: (base: any) => ({
    ...base,
    width: 'auto',
    height: '42px',
    backgroundColor: '#fff',
    border: 'solid 1px #e8e8e8',
    borderRadius: '5px',
    paddingLeft: '2px',
    paddingRight: '5px',
    color: '#969696',
    fontSize: '14px',
    fontWeight: '400',
    lineHeight: '40px',
    boxShadow: 'none',
  }),
  option: (base: any, state: any) => ({
    ...base,
    backgroundColor: state.isSelected
      ? '#f3f3f3'
      : state.isFocused
      ? '#f6f6f6'
      : 'white',
    color: '#343434',
    fontWeight: state.isSelected ? '700' : '400',
    fontSize: '14px',
    paddingLeft: 18,
    paddingRight: 29,
    lineHeight: '20px',
    cursor: 'pointer',
  }),
  singleValue: (base: any) => ({
    ...base,
    color: '#343434',
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
  dropdownIndicator: (base: any, state: any) => ({
    ...base,
    color: '#999',
    transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
    transition: 'transform 0.2s ease',
  }),
};

function renderStars(rating: number) {
  const fullStars = Math.floor(rating);
  const halfStar = rating % 1 >= 0.5;
  const emptyStars = 5 - fullStars - (halfStar ? 1 : 0);

  return (
    <>
      {Array(fullStars)
        .fill(0)
        .map((_, i) => (
          <li key={`full-${i}`}>
            <img className="star-rating-icon h-[17px]" src="/images/rating-star-full.svg" alt="" />
          </li>
        ))}
      {halfStar && (
        <li>
          <img className="star-rating-icon h-[17px]" src="/images/rating-star-half.svg" alt="" />
        </li>
      )}
      {Array(emptyStars)
        .fill(0)
        .map((_, i) => (
          <li key={`empty-${i}`}>
            <img className="star-rating-icon h-[17px]" src="/images/rating-star-blank.svg" alt="" />
          </li>
        ))}
    </>
  );
}

function useIsMobile(maxWidth = 991) {
  const [isMobile, setIsMobile] = useState(false);

  useEffect(() => {
    const check = () => setIsMobile(window.innerWidth <= maxWidth);
    check();
    window.addEventListener('resize', check);
    return () => window.removeEventListener('resize', check);
  }, [maxWidth]);

  return isMobile;
}

export default function ProductReviewList({ name }: ProductProps) {
  const [activeTab, setActiveTab] = useState(0);
  const [sortOption, setSortOption] = useState(sortOptions[0]);
  const isMobile = useIsMobile();

  const renderTabContent = (index: number) => {
    if (index === 0) {
      return (
        <div className="reviews-holder">
              <div className="product-name-heading flex justify-between items-center my-[40px]
                max-xl:my-[20px] max-md:flex-col max-md:items-start max-md:gap-x[32px] max-md:gap-y-[15px]">
                <h5 className="text-[24px] text-[#323232] font-bold !leading-[1.20]
                  max-xl:text-xl">{ name } Reviews
                </h5>
                <div className="w-48">
                  <Select
                    options={sortOptions}
                    value={sortOption}
                    onChange={(opt) => opt && setSortOption(opt)}
                    className="text-sm"
                    styles={customStyles}
                  />
                </div>
              </div>

              <div className="review-card--holder">
                {reviews.map((review, i) => (
                  <div key={i} className="review-card-type2 mb-[34px] pb-[24px] border-b border-[#d9d9d9] flex w-full 
                    max-md:flex-wrap max-md:gap-y-[25px]">
                    <div className="profile-details w-[142px] text-center
                      max-md:w-full max-md:text-left">
                      <img className="profile-image w-[77px] h-[77px] rounded-[50%] mb-[20px] md:mx-auto
                        max-md:w-[62px] max-md:h-[62px] max-md:mb-[10px]" 
                        src={review.profileImage} alt="" />
                      <span className="profile-name block text-[#3f97ff] text-sm font-medium">{review.name}</span>
                      <span className="location text-[#666] text-sm">{review.location}</span>
                      <hr className="bg-[#e2e2e2] max-w-[115px] mx-auto mt-[15px]
                        max-md:max-w-full" />
                      <ul className="mt-0 pt-[15px] max-md:flex max-md:flex-wrap max-md:gap-[10px]">
                        <li className="text-[#666] text-sm font-medium !leading-[1.45]">3 Reviews</li>
                        <li className="text-[#666] text-sm font-medium !leading-[1.45]">2 Followers</li>
                      </ul>
                    </div>
                    <div className="review-content w-[calc(100%-142px)] max-l:pl-[15px] pl-[35px] relative
                      max-md:!w-[calc(100%-0px)] max-md:pl-0">
                      <h6 className="mb-[13px] text-base font-bold text-[#323232] !leading-[1.20]">Lakme Foundation</h6>
                      <div className="review-rating-detail flex flex-wrap items-center gap-x-[16px] gap-y-[8px] mb-[13px]">
                        <div className="star-icons flex">
                          <ul className="mr-0 flex items-center gap-[2px] w-auto p-0 rounded-[50px] !leading-0
                            max-md:p-[4px_7px_4px_0px]">
                            {renderStars(review.rating)}
                          </ul>
                        </div>
                          <span className="date text-[#666] text-sm">{review.date}</span>
                          <span className="views text-[#666] text-sm items-center">
                            <i className="icon-view-solid text-[18px] mr-[5px]"></i> 
                            {review.views} Views
                          </span>
                      </div>
                      <p className="text-[#666] text-base font-medium !leading-[1.60]
                        max-md:text-[15px]">{review.review}</p>
                      <Link className="pin-comment absolute right-0 bottom-[30px] text-[18px] text-[#666]" href="">
                        <span className="icon-flag"></span>
                      </Link>
                      <div className="footer-actions mt-[44px] flex flex-wrap items-center justify-between
                        gap-y-[12px] gap-x-[10px] relative">
                        <ul className="flex flex-wrap gap-x-[14px] gap-y-[12px]">
                          <li className="text-[#666] text-sm font-medium !leading-[1.07]">
                            <Link href="#"><i className="icon-like-solid"></i> Like <span>0</span>
                            </Link>
                          </li>
                          <li className="text-[#666] text-sm font-medium !leading-[1.07]">
                            <Link href="#"><i className="icon-comment-solid"></i> Comments <span>0</span>
                            </Link>
                          </li>
                          <li className="text-[#666] text-sm font-medium !leading-[1.07]">
                            <Link href="#"><i className="icon-share-solid"></i> Share
                            </Link>
                          </li>
                        </ul>
                        <Link className="flex items-center text-sm" href="/#">
                          <img className="w-4 h-4 mr-2" src="/images/icon-share.svg" alt="" />Reply As Brand
                        </Link>
                      </div>
                    </div>
                  </div>
                ))}
              </div>
            </div>
          )}
      
    if (index === 1) return <div className="photos-holder py-10">[Photos Section]</div>;
    if (index === 2) return <div className="qa-holder py-10">[Q&A Section]</div>;
    return null;
  };

  return (
    <div className="product-review-list bg-white py-[24px] px-[50px] mt-[-20px] rounded-[20px] max-xl:py-[24px] max-xl:px-[30px]
      max-md:py-[24px] max-md:px-[20px]">
      <div id="productDetailTabs">
        {!isMobile ? (
          <ul className="resp-tabs-list border-b border-[#dfdcdc]">
            {tabOptions.map((tab, index) => (
              <li
                key={tab}
                className={`cursor-pointer text-[#666] text-sm font-bold !leading-[1] inline-block py-[13px] px-[15px] mr-[4px] transition-all duration-300 ease-in-out ${
                  activeTab === index
                    ? 'border-b-[3px] border-[#713fff] text-[#713fff]'
                    : 'text-[#666]'
                }`}
                onClick={() => setActiveTab(index)}
              >
                {tab}
              </li>
            ))}
          </ul>
        ) : (
          <div className="resp-tabs-container p-0 bg-white clear-left">
            {tabOptions.map((tab, index) => (
              <div key={tab}>
                <h2
                  className={`resp-accordion w-full relative py-[20px] pl-0 pr-0 text-[18px] font-inter text-[#666] block bg-white flex justify-between items-center ${activeTab === index ? 'active' : ''}`}
                  onClick={() => setActiveTab(index === activeTab ? -1 : index)}
                >
                  {tab}
                  <svg
                    className={`w-4 h-4 ml-2 transform transition-transform duration-300 
                    ${activeTab === index ? 'rotate-180' : 'rotate-0'}`}
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="3" d="M22 9l-9 9-9-9"></path>
                  </svg>
                </h2>
                {activeTab === index && <div className="">{renderTabContent(index)}</div>}
              </div>
            ))}
          </div>
        )}
        {!isMobile && <div className="">{renderTabContent(activeTab)}</div>}
      </div>
    </div>
  );
}
