
import Link from 'next/link'

interface ProductImageProps {
  image: string;
  name: string;
}

export default function ProductImage({ image, name }: ProductImageProps){
	return(
		<>
		<div className="product-image w-full h-[287px] mx-auto p-[20px] flex justify-center items-center 
			bg-white border border-[#e0ddea] rounded-[11px]">
           	<img src={`/${image}`} alt={`${name}`} className="max-w-full max-h-full" />
    </div>
    <Link className="ms-btn primary-solid !w-full !mt-[14px] max-l:!py-[16px] max-l:!px-[40px] max-l:!text-[18px]" href="/#">
    Write Your Review</Link>
		</>
		);
}