import Image from 'next/image'
import Link from 'next/link'

export default function GetAssistance(){
	return(
		<>
		<section className="get-assistance-block pb-[95px]">
			<div className="container mx-auto px-4">
				<div className="flex flex-col lg:flex-row items-start gap-8 bg-white rounded-[15px] pt-[70px]">
					
					<div className="w-full lg:w-5/12 order-1 lg:order-none">
						<Image className="max-w-[452px] w-full max-480:max-w-[280px] max-480:mx-auto max-480:flex max-480:items-center" 
							src="/images/vector-help-centre.svg" 
							width={449}
							height={375}
							alt="" />
						</div>
						
						<div className="w-full lg:w-7/12 flex flex-col items-center lg:items-start">
							<div className="section-content mt-[30px] max-w-[653px] max-l:mt-[0px] max-l:px-[20px] max-l:text-center">
								<h2 className="mb-[43px] max-md:text-[36px] max-sm:text-[30px] max-l:text-center">
									Get Assistance: <span className="block">Explore Our Help Centre</span>
								</h2>
								<Link href="/help-center" 
									className="inline-flex w-full max-l:text-base max-w-[368px] items-center justify-center gap-3 
									bg-[#713fff] text-white text-xl font-semibold max-l:py-[22px] max-l:px-[30px] px-12 py-6 rounded-[49px] hover:bg-[#5e30db] 
									transition-colors duration-300">
									<span className="icon-headphone text-xl"></span> 
									Need Support
								</Link>

							</div>
						</div>

					</div>
				</div>
			</section>
		</>
		);
}