'use client';

import { useState } from 'react';
import Link from 'next/link';


type PlanCardProps = {
  title: string;
  price: number;
  features: string[];
};


export default function PricingPlans() {
  const [isEnterprise, setIsEnterprise] = useState(false);

  return (
    <section className="pt-[50px] pb-[65px] max-l:pt-[38px] max-l:pb-[50px] max-3xl:pt-[55px] max-3xl:pb-[70px] 3xl:pt-[60px] 3xl:pb-[80px]  bg-[#f5f5f5] plan-stage">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12 max-l:mb-4">
          <h2 className="mb-7">Plans for every stage</h2>
              <div className="flex items-center justify-center gap-4 plan-selector">
                <span className={`max-l:text-base text-[18px] font-medium leading-none transition-colors duration-300 ${!isEnterprise ? 'text-[#713fff]' : 'text-black'}`}>
                  Plans for <b>Everyone</b>
                </span>

                <label className="relative inline-block w-[80px] h-[40px] cursor-pointer plan-changer">
                  <input
                    type="checkbox"
                    className="sr-only peer"
                    checked={isEnterprise}
                    onChange={() => setIsEnterprise(!isEnterprise)}
                  />
                  <div className="bg-white border border-[#713fff] peer-checked:bg-[#ffffff] peer-checked:border-[#713fff] absolute inset-0 rounded-full transition duration-300"></div>
                  <div className="slide-round absolute top-1 left-1 w-8 h-8 bg-[#713fff] rounded-full shadow-md transition-transform duration-300 peer-checked:translate-x-10"></div>
                </label>

                <span className={`max-l:text-base text-[18px] font-medium leading-none transition-colors duration-300 ${isEnterprise ? 'text-[#713fff]' : 'text-black'}`}>
                  Plans for <b>Enterprise</b>
                </span>
              </div>

          </div>

        {/* Plans */}
        <div className="relative min-h-[400px]">
          <div className={`transition-opacity duration-500 ${isEnterprise ? 'opacity-0 absolute pointer-events-none' : 'opacity-100'}`}>
            <div className="grid max-l:grid-cols-1 grid-cols-1 md:grid-cols-3 gap-2 max-l:gap-6">
              {everyonePlans.map((plan, index) => (
                <PlanCard key={index} {...plan} />
              ))}
            </div>
        </div>

        <div className={`transition-opacity duration-500 ${isEnterprise ? 'opacity-100' : 'opacity-0 absolute pointer-events-none'}`}>
          <div className="grid max-l:grid-cols-1 grid-cols-1 md:grid-cols-3 gap-2 max-l:gap-6">
            {enterprisePlans.map((plan, index) => (
              <PlanCard key={index} {...plan} />
            ))}
          </div>
        </div>
      </div>
      </div>
    </section>
  );
}

const PlanCard = ({ title, price, features }: PlanCardProps) => (

  <div className="p-6 plan-card max-l:max-w-[428px] shadow hover:shadow-lg transition mx-auto rounded-[20px] px-[28px] pt-[45px] pb-[34px] bg-white overflow-hidden">
    <h4 className="text-[32px] max-xl:text-[30px] max-md:text-[26px] font-bold mb-[5px] font-nunito">{title}</h4>
    <p className="font-normal text-base mb-[14px] text-[#6d6d6d]">Lorem Ipsum is simply dummy text of the printing and typesetting industry.
    </p>
    <div className="text-lg max-l:text-[15px] text-[#6d6d6d] font-medium block">Start</div>
    <h3 className="text-[40px] max-xl:text-[36px] max-sm:text-[28px] text-[#323232] font-bold xl:my-2">${price}<sup className="max-sm:text-[24px] text-[32px] max-xl:text-[28px] font-bold -top-[0.2em] max-xl:-top-[0.1em]">/m</sup></h3>
    <span className="text-lg max-l:text-[15px] text-[#6d6d6d] font-normal block">Per Domain</span>
    <Link className="card-btn hover:bg-[#713fffcc] my-[15px]" href="#">
      Book Demo
    </Link>
    <ul className="text-sm text-gray-700 mb-4 list-none space-y-2 card-item">
      {features.map((feature, i) => (
        <li className="relative pl-6 mb-[17px] text-base max-l:tetx-[14px] max-l:mb-[12px] tetx-[#6d6d6d] font-medium opacity-80" key={i} dangerouslySetInnerHTML={{ __html: feature }} />
      ))}
    </ul>
    <Link className="block hover:bg-[#713fff] hover:text-[#ffffff] text-center border text-[#263238] border-[#26323866] 
      px-[20px] py-[14px] rounded-[5px] my-[15px] text-base font-normal" href="#">
      View all features
    </Link>
  </div>
);

const everyonePlans = [
  {
    title: 'Standard',
    price: 250,
    features: [
      "<b>500</b> verified review invitations per month",
      "<b>500</b> additional invitations for past customers in each of your first three months",
      "<b>8</b> website widgets to display your star rating and review count",
      "An <b>ad-free</b> profile page",
      "<b>Image and video</b> generators",
      "<b><b>Social</b> sharing",
      "<b>Analytics</b> dashboards to learn more from your feedback",
      "Third-party <b>eCommerce, helpdesk,</b> and <b>marketing integrations</b>",
    ],
  },
  {
    title: 'Plus',
    price: 500,
    features: [
      "<b>500</b> verified review invitations per month",
      "<b>500</b> additional invitations for past customers in each of your first three months",
      "<b>8</b> website widgets to display your star rating and review count",
      "An <b>ad-free</b> profile page",
      "<b>Image and video</b> generators",
      "<b><b>Social</b> sharing",
      "<b>Analytics</b> dashboards to learn more from your feedback",
      "Third-part <b>eCommerce, helpdesk,</b> and <b>marketing integrations</b>",
    ],
  },
  {
    title: 'Premium',
    price: 750,
    features: [
      "<b>500</b> verified review invitations per month",
      "<b>500</b> additional invitations for past customers in each of your first three months",
      "<b>8</b> website widgets to display your star rating and review count",
      "An <b>ad-free</b> profile page",
      "<b>Image and video</b> generators",
      "<b><b>Social</b> sharing",
      "<b>Analytics</b> dashboards to learn more from your feedback",
      "Third-part <b>eCommerce, helpdesk,</b> and <b>marketing integrations</b>",
    ],
  },
];

const enterprisePlans = [
  {
    title: 'Enterprise Basic',
    price: 1200,
    features: [
      "<b>500</b> verified review invitations per month",
      "<b>500</b> additional invitations for past customers in each of your first three months",
      "<b>8</b> website widgets to display your star rating and review count",
      "An <b>ad-free</b> profile page",
      "<b>Image and video</b> generators",
      "<b><b>Social</b> sharing",
      "<b>Analytics</b> dashboards to learn more from your feedback",
      "Third-part <b>eCommerce, helpdesk,</b> and <b>marketing integrations</b>",
    ],
  },
  {
    title: 'Enterprise Pro',
    price: 2000,
    features: [
      "<b>500</b> verified review invitations per month",
      "<b>500</b> additional invitations for past customers in each of your first three months",
      "<b>8</b> website widgets to display your star rating and review count",
      "An <b>ad-free</b> profile page",
      "<b>Image and video</b> generators",
      "<b><b>Social</b> sharing",
      "<b>Analytics</b> dashboards to learn more from your feedback",
      "Third-part <b>eCommerce, helpdesk,</b> and <b>marketing integrations</b>",
    ],
  },
  {
    title: 'Enterprise Elite',
    price: 3000,
    features: [
      "<b>500</b> verified review invitations per month",
      "<b>500</b> additional invitations for past customers in each of your first three months",
      "<b>8</b> website widgets to display your star rating and review count",
      "An <b>ad-free</b> profile page",
      "<b>Image and video</b> generators",
      "<b><b>Social</b> sharing",
      "<b>Analytics</b> dashboards to learn more from your feedback",
      "Third-part <b>eCommerce, helpdesk,</b> and <b>marketing integrations</b>",
    ],
  },
];