
'use client';

import { useState } from "react";
import { motion, AnimatePresence } from "framer-motion";

const faqs = [
  {
    question: "What types of reviews does your platform support?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How does your AI detect fake reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can businesses respond to reviews on your platform?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can users report suspicious reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How can businesses integrate your review analysis into their systems?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How does your AI detect fake reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can businesses respond to reviews on your platform?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can users report suspicious reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How can businesses integrate your review analysis into their systems?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
];

export default function PriceFaq() {
  const [openIndex, setOpenIndex] = useState<number | null>(null);

  const toggleIndex = (index: number) => {
    setOpenIndex(openIndex === index ? null : index);
  };

  return (
    <section className="PriceFaq py-[75px]">
      <div className="container mx-auto px-4">
      <h2 className="text-[40px] llg:text-[48px] mb-[40px] max-l:text-center max-sm:text-[30px] max-md:text-[36px] max-md:mb-[20px]">
        Frequently Asked Questions</h2>
        <div className="flex flex-col lg:flex-row gap-8 faq-holder bg-white rounded-[29px] max-sm:py-[30px] max-sm:px-[10px] max-md:p-[30px] p-[68px]">
        <div className="w-full">
          {faqs.map((faq, index) => (
            <div
              key={index}
              className="py-6 cursor-pointer px-4 max-xl:p-[20px]"
            >
              <div
                className="flex gap-4"
                onClick={() => toggleIndex(index)}
              >
                <img
                  src={openIndex === index ? "/images/faq-active.svg" : "/images/faq-inactive.svg"}
                  alt={openIndex === index ? "Collapse" : "Expand"}
                  className="shrink-0 max-sm:hidden"
                />
                <h4 className="text-[20px] max-xl:text-lg max-md:text-base font-semibold leading-tight">
                  {faq.question}
                </h4>
              </div>

              <AnimatePresence initial={false}>
                {openIndex === index && (
                  <motion.div
                    initial={{ height: 0, opacity: 0 }}
                    animate={{ height: "auto", opacity: 1 }}
                    exit={{ height: 0, opacity: 0 }}
                    transition={{ duration: 0.3 }}
                    className="overflow-hidden pl-8 pr-2"
                  >
                    <p className="text-gray-600 mt-2">{faq.answer}</p>
                  </motion.div>
                )}
              </AnimatePresence>
            </div>
        ))}
      </div>
    </div>
    </div>
  </section>

  );
}
