'use client';

import React, { useState } from 'react';
import Select, { SingleValue, StylesConfig } from 'react-select';
import Link from 'next/link'

interface OptionType {
  value: string;
  label: string;
}

const partnerOptions: OptionType[] = [
  { value: ' ', label: 'Partner Type' },
  { value: 'reseller', label: 'Reseller' },
  { value: 'vendor', label: 'Vendor' },
];

const countryOptions: OptionType[] = [
  { value: 'india', label: 'India' },
  { value: 'usa', label: 'USA' },
];

const customStyles: StylesConfig<OptionType, false> = {
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected
      ? '#f3f3f3'
      : state.isFocused
      ? '#f6f6f6'
      : 'white',
    color: '#8794a4',
    padding: 10,
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: state.isSelected ? '700' : '400',
  }),
  control: (base, state) => ({
    ...base,
    width: '100%',
    color: '#8794a4',
    fontWeight: 400,
    fontSize: 16,
    padding: '7px',
    border: '1px solid #dad6e5',
    borderRadius: 5,
    backgroundColor: '#fefefe',
    boxShadow: state.isFocused ? '0 0 0 1px #e8e8e8' : 'none',
    '&:hover': {
      borderColor: '#e8e8e8',
    },
  }),
  singleValue: (base) => ({
    ...base,
    maxWidth: '100%',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    color: '#8794a4',
    marginLeft: '2px',
    marginRight: '2px',
    fontWeight: 400,
    textAlign: 'left',
    // Responsive font size
  '@media (max-width: 991px)': {
    fontSize: '15px !important',
  },
  }),
  dropdownIndicator: (base, state) => ({
        ...base,
        color: '#8794a4',
        transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
        transition: 'transform 0.2s ease',
        svg: {
          fill: '#8794a4',
          stroke: '#8794a4',
          strokeWidth: 0,
      },
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
};

export default function PartnersBanner() {
  const [selectedPartner, setSelectedPartner] = useState<OptionType>(partnerOptions[0]);

  const handlePartnerChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedPartner(option);
  };

  const [selectedCountry, setSelectedCountry] = useState<OptionType>(countryOptions[0]);

  const handleCountryChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedCountry(option);
  };

  return (
    <section className="partners-banner max-xl:pt-[140px] pt-[70px]">
      <div className="container mx-auto px-4">
        <div className="content--area flex max-xl:flex-col max-xl:text-center justify-between gap-[30px]">
          {/* Left Column */}
          <div className="text--area max-w-[637px] mx-auto">
            <h1 className="font-extrabold mb-[30px] max-sm:text-[36px] max-xl:text-[54px]">Partner with YourReview today</h1>
            <p className="text-[#6d6d6d] text-base font-medium leading-[1.54] max-w-[566px] max-xl:max-w-full">
              Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
              been the industry's standard dummy text ever since the 1500s, when an unknown printer took a
              galley of type and scrambled it to make a type.
            </p>
            <span className="sub-text block mt-[45px] mb-[13px] font-medium leading-[1.54]">
              <b>Already a Partner?</b>
            </span>
            <Link className="primary-link with-arrow !mt-0 !text-[#713fff] !text-base max-md:pr-0 pr-[80px] !underline" href="">
              Log in to the partner portal
            </Link>
          </div>

          {/* Right Column Form */}
          <div className="become-partner-form max-w-[610px] 
            max-l:py-[30px] max-l:px-[15px] p-[34px_45px_60px_45px] mb-[-55px] bg-white rounded-[22px] max-xl:mx-auto max-l:w-full
            max-sm:w-auto">
            <h4 className="max-md:text-[26px] max-xl:text-3xl llg:font-nunito llg:text-3xl text-[#263238] mb-[20px] font-bold 
              !leading-[1.07] text-center">
              Become a Partner Today</h4>
            <form className="grid max-sm:grid-cols-1 grid-cols-2 gap-y-[13px] gap-x-[12px]">
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="First name" />
              </div>
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]"
                  type="text" placeholder="Last name" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="email" placeholder="Business Email" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="Company Name" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <Select
                  options={partnerOptions}
                  value={selectedPartner}
                  onChange={handlePartnerChange}
                  classNamePrefix="react-select"
                  placeholder="Partner Type"
                  styles={customStyles}
                />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="url" placeholder="Website URL" />
              </div>
              <div className="form-field">
                <Select
                  options={countryOptions}
                  value={selectedCountry}
                  onChange={handleCountryChange}
                  classNamePrefix="react-select"
                  placeholder="Country"
                  styles={customStyles}
                />
              </div>
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="Phone number" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <button type="submit" className="ms-btn primary-solid btn-md w-full !block !mt-[5px] max-l:!py-[16px] !py-[14px] !px-[20px]
                  max-l:!text-[15px] !text-[16px]">
                  Send
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </section>
  );
}
