import Link from 'next/link'

export default function ModuleCards(){
	return(
		<>
		<section className="module-cards module-cards-bg bg-[#f5f5f5] max-md:pt-[90px] max-md:pb-[40px] pt-[92px] pb-[77px]">
		    <div className="container mx-auto px-4">
		        <div className="heading-content max-md:mb-[20px] mb-[50px] text-center">
		            <h2 className="pb-[14px]">Choose the Partnership that’s Right for You</h2>
		        </div>
		        <div className="module-cards-content">
		            <div className="row flex flex-wrap -mx-3 -mt-6">
		                <div className="w-full lg:w-1/2 llg:w-1/3 px-3 max-md:mt-[12px] mt-6">
		                    <div className="item flex max-md:p-[30px] max-md:gap-[15px] max-xxl:flex-col gap-[22px] 
		                    	max-w-[416px] py-[37px] px-[42px]
		                    	mx-auto rounded-[20px] bg-white">
		                        <figure>
		                            <img src="images/referral-partner-program-icon.svg" alt="Icon"
		                            />
		                        </figure>
		                        <div className="details">
		                            <h6 className="mb-[12px] text-[#343434] text-[20px] font-bold">Referral Partner Program</h6>
		                            <p className="max-md:mb-[12px] mb-[20px] text-[#6d6d6d] max-md:text-[15px] text-base !leading-[1.58]">
		                            	Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
		                                Ipsum has been the industry's standard dummy text.</p>
		                            <Link className="primary-link with-arrow !mt-0 max-l:!text-sm !text-base !font-semibold 
		                            	max-md:pr-0 pr-[80px] !underline" href="">
		                            	Learn More
		                            </Link>
		                        </div>
		                    </div>
		                </div>
		                <div className="w-full lg:w-1/2 llg:w-1/3 px-3 mt-6">
		                    <div className="item flex max-md:p-[30px] max-md:gap-[15px] max-xxl:flex-col gap-[22px] 
		                    	max-w-[416px] py-[37px] px-[42px]
		                    	mx-auto rounded-[20px] bg-white">
		                        <figure>
		                            <img src="images/trusted-integration-icon.svg" alt="Icon"
		                            />
		                        </figure>
		                        <div className="details">
		                            <h6 className="mb-[12px] text-[#343434] text-[20px] font-bold">Trusted Integration</h6>
		                            <p className="max-md:mb-[12px] mb-[20px] text-[#6d6d6d] max-md:text-[15px] text-base !leading-[1.58]">
		                            	Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
		                                Ipsum has been the industry's standard dummy text.</p>
		                            <Link  className="primary-link with-arrow !mt-0 !text-base !font-semibold 
		                            	max-md:pr-0 pr-[80px] !underline" href="">
		                            	Learn More
		                            </Link>
		                        </div>
		                    </div>
		                </div>
		                <div className="w-full lg:w-1/2 llg:w-1/3 px-3 mt-6">
		                    <div className="item flex max-md:p-[30px] max-md:gap-[15px] max-xxl:flex-col gap-[22px] 
		                    	max-w-[416px] py-[37px] px-[42px]
		                    	mx-auto rounded-[20px] bg-white">
		                        <figure>
		                            <img src="images/review-syndication.svg" alt="Icon"
		                            />
		                        </figure>
		                        <div className="details">
		                            <h6 className="mb-[12px] text-[#343434] text-[20px] font-bold">Review Syndication</h6>
		                            <p className="max-md:mb-[12px] mb-[20px] text-[#6d6d6d] max-md:text-[15px] text-base !leading-[1.58]">
		                            	Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
		                                Ipsum has been the industry's standard dummy text.</p>
		                            <Link  className="primary-link with-arrow !mt-0 !text-base !font-semibold 
		                            	max-md:pr-0 pr-[80px] !underline" href="">
		                            	Learn More
		                            </Link>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}