import Image from 'next/image'

export default function IntegrationProgram(){
	return(
		<>
		<div className="block-with-points integration-program max-mmd:pt-[40px] max-mmd:pb-0 max-xl:pt-[50px] 
			max-3xl:pt-[65px] pt-[68px]">
		    <div className="container mx-auto px-4">
		        <div className="block-with-points-content">
		            <h2 className="text-center max-mmd:mb-[15px] max-xl:mb-[25px] mb-[40px]">Trusted Integration Program tiers</h2>
		            <div className="row flex flex-wrap -mx-3">
		                <div className="w-full llg:w-1/2 px-3">
		                    <div className="points">
		                        <ul>
		                            <li className="flex max-mmd:flex-col gap-[14px] mb-[14px] max-xl:p-[23px] py-[30px] px-[35px] rounded-[10px] bg-white">
		                                <img src="images/tick--icon-3.svg" alt="Tick"
		                                	 className="block max-xl:w-[34px] max-xl:h-[34px] w-[42px] h-[42px]"
		                                />
		                                <div className="details">
		                                    <span className="block mb-[4px] text-[#713fff] text-[13px] font-medium uppercase">
		                                    	Entry Tier
		                                    </span>
		                                    <h6 className="mb-[8px] text-[#343434] max-l:text-lg text-xl font-bold !leading-[1.07]">
		                                    	Launch
		                                    </h6>
		                                    <p className="text-[#6d6d6d] max-mmd:text-sm max-xl:text-[15px] text-base font-normal !leading-[1.58] tracking-[-0.1px]">
		                                    	Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		                                    	Lorem Ipsum has been the industry's standard dummy text</p>
		                                </div>
		                            </li>

		                            <li className="flex max-mmd:flex-col gap-[14px] mb-[14px] max-xl:p-[23px] py-[30px] px-[35px] rounded-[10px] bg-white">
		                                <img src="images/tick--icon-3.svg" alt="Tick"
		                                	 className="block max-xl:w-[34px] max-xl:h-[34px] w-[42px] h-[42px]" 
		                                />
		                                <div className="details">
		                                    <span className="block mb-[4px] text-[#713fff] text-[13px] font-medium uppercase">
		                                    	Mid Tier
		                                    </span>
		                                    <h6 className="mb-[8px] text-[#343434] max-l:text-lg text-xl font-bold !leading-[1.07]">
		                                    	Growth</h6>
		                                    <p className="text-[#6d6d6d] max-mmd:text-sm max-xl:text-[15px] text-base font-normal !leading-[1.58] tracking-[-0.1px]">
		                                    	Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		                                    	Lorem Ipsum has been the industry's standard dummy text</p>
		                                </div>
		                            </li>

		                            <li className="flex max-mmd:flex-col gap-[14px] mb-0 max-xl:p-[23px] py-[30px] px-[35px] rounded-[10px] bg-[#e5e2f1]">
		                                <img src="images/tick--icon-3.svg" alt="Tick"
		                                	 className="block max-xl:w-[34px] max-xl:h-[34px] w-[42px] h-[42px]"
		                                />
		                                <div className="details">
		                                    <span className="block mb-[4px] text-[#713fff] text-[13px] font-medium uppercase">
		                                    	Top Tier
		                                    </span>
		                                    <h6 className="mb-[8px] text-[#343434] max-l:text-lg text-xl font-bold !leading-[1.07]">
		                                    	Prestige</h6>
		                                    <p className="text-[#6d6d6d] max-mmd:text-sm max-xl:text-[15px] text-base font-normal !leading-[1.58] tracking-[-0.1px]">
		                                    	Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		                                    	Lorem Ipsum has been the industry's standard dummy text</p>
		                                </div>
		                            </li>
		                        </ul>
		                    </div>
		                </div>
		                <div className="w-full llg:w-1/2 px-3">
		                    <div className="image--area">
		                        <Image src="/images/vector-trusted_integration_program.svg" alt="Image"
		                        	   width={594}
		                        	   height={446}
		                        	   className="block max-w-full mx-auto"
		                        />
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</div>
		</>
		);
}