

export default function BusinessOutcome() {
	return(
		<>
		<section className="pt-[95px] business-outcome">
			<div className="container mx-auto px-4">
				<div className="section-holder max-md:!px-[50px] max-xxl:max-w-[1062px] bg-white relative py-[40px] px-[104px] max-xxl:pl-[400px] rounded-[20px] ml-auto">
					<div className="flex flex-col gap-6">
						<div className="text-center quote max-l:!left-[-30px] max-xxl:!left-[-50px]">
							<h5 className="text-[30px] font-bold text-white font-nunito max-w-[263px]">
								We unite consumers and businesses to enhance outcomes.
							</h5>
						</div>

						<div className="flex items-start gap-6 brief__heading customer-exp pb-[25px] border-b border-[#ededed]">
							<div className="w-12">
								<img src="images/cart-icon-gray.svg" alt="Consumers Icon" />
							</div>
							<div>
								<span className="block text-sm font-bold text-[#6d6d6d] leading-[1.73]">Consumers:</span>
								<h4 className="font-nunito font-bold max-md:text-[26px] max-xl:text-[30px] text-[32px] leading-[1.20] text-[#323232]">Exchange your experiences</h4>
							</div>
						</div>

						<div className="flex items-start gap-6 brief__heading">
							<div className="w-12">
								<img src="images/cart-icon-shop.svg" alt="Businesses Icon" />
							</div>
							<div>
								<span className="block text-sm font-bold text-[#6d6d6d] leading-[1.73]">Businesses:</span>
								<h4 className="font-nunito font-bold max-md:text-[26px] max-xl:text-[30px] text-[32px] leading-[1.20] text-[#323232]">Craft enhanced experiences</h4>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		</>
		);
}