import Image from 'next/image'
import Link from 'next/link'

export default function HighlattedNewscard(){
	return(
		<>
		<section className="highlatted-newscard news-card-styles">
			<div className="container mx-auto px-4">
				<div className="card-holder flex max-md:flex-col items-stretch">
					<Link href="news-and-updates-details.html">
					<figure className="max-md:w-full max-l:w-[300px] max-xxl:w-[456px] w-[617px] h-full flex-shrink-0">
						<Image src="/images/image-news-details.jpg"
							width={899} 
							height={495} 
							alt="image-news-details.jpg"
							className="w-full h-full object-cover object-center max-md:rounded-[20px_20px_0px_0px] rounded-[20px_0px_0px_20px]" />
						</figure>
					</Link>
					<div className="news-details bg-white max-xl:py-[50px] max-xl:px-[40px] max-md:p-[30px] p-[68px_64px_68px_78px] 
						max-md:rounded-[0px_0px_20px_20px] rounded-[0px_20px_20px_0px] relative">
						<span className="news-label text-[#713fff] text-base font-medium leading-[1.54] mb-[30px]">YourReviews announcements</span>
						<Link className="card__link block text-[#323232]" href="/#">
						<h4 className="max-md:text-[26px] max-l:text-3xl lg:text-4xl font-bold font-nunito text-[#000 tracking-[1.44px] overflow-hidden line-clamp-4">
							Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print
						</h4>
					</Link>
					<div className="news-time mt-[45px] flex flex-wrap gap-[10px]">
						<span className="date text-[#a39fac]">March 25. 2024</span>
						<span className="text-[#a39fac]">|</span>
						<span className="location text-[#a39fac]">United States</span>
					</div>
				</div>
			</div>
		</div>
	</section>
		</>
		);
}