    import Link from 'next/link'

    export default function RelationsNumeric(){
    	return(
    		<>
    		<section className="investor-relations-numeric max-l:py-[50px] max-xl:py-[60px] py-[85px] bg-[#f5f5f5]">
                <div className="container mx-auto px-4">
                    <div className="investor-relations-numeric-content">
                        <div className="row flex flex-wrap">
                            <div className="xl:w-5/12">
                                <div className="image--area w-full max-xl:block max-xl:mb-[40px] max-w-[387px]">
                                    <img src="images/globe-image.svg" alt="Image" className="block max-w-full" />
                                </div>
                            </div>
                            <div className="xl:w-7/12">
                                <div className="counter--area grid max-md:grid-cols-1 max-md:gap-[30px] grid-cols-2 gap-y-[80px] gap-x-[30px]">
                                    <div className="item relative px-[16px]">
                                        <h4 className="max-l:mb-[5px] mb-[9px] font-bold max-l:text-[24px] max-xl:text-[30px] max-xxl:text-[35px] text-[40px]">+1.1m</h4>
                                        <span className="subtitle block max-md:mb-[2px] mb-[7px] text-[#000] max-md:text-[15px] text-base font-semibold leading-[1.51]">Reviewed domains</span>
                                        <p className="text-[#808080] max-md:leading-[1.30] max-md:text-sm text-base font-medium leading-[1.51]">More than 1.1 million businesses have been reviewed on YourReviews</p>
                                    </div>
                                    <div className="item relative px-[16px]">
                                        <h4 className="max-l:mb-[5px] mb-[9px] font-bold max-l:text-[24px] max-xl:text-[30px] max-xxl:text-[35px] text-[40px]">+116K</h4>
                                        <span className="subtitle block max-md:mb-[2px] mb-[7px] text-[#000] max-md:text-[15px] text-base font-semibold leading-[1.51]">Active domains</span>
                                        <p className="text-[#808080] max-md:leading-[1.30] max-md:text-sm text-base font-medium leading-[1.51]">These are businesses inviting reviews</p>
                                    </div>
                                    <div className="item relative px-[16px]">
                                        <h4 className="max-l:mb-[5px] mb-[9px] font-bold max-l:text-[24px] max-xl:text-[30px] max-xxl:text-[35px] text-[40px]">c.$200 million</h4>
                                        <span className="subtitle block max-md:mb-[2px] mb-[7px] text-[#000] max-md:text-[15px] text-base font-semibold leading-[1.51]">Annual recurring revenue</span>
                                        <p className="text-[#808080] max-md:leading-[1.30] max-md:text-sm text-base font-medium leading-[1.51]">Supported by 99% LTM net dollar retention rate</p>
                                    </div>
                                    <div className="cta flex flex-col justify-center items-start bg-[#e0e0e9] rounded-[17px] py-5 px-[30px]">
                                        <span className="subtitle text-[#000] mb-[14px] font-bold text-base leading-[1.47]">Annual recurring revenue</span>
                                        <Link className="ms-btn primary-solid btm-sm !text-[14px] max-l:py-4 max-l:px-10" href="/#">Result Centre</Link>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            </>
            );
    	
    }