import Link from 'next/link'

export default function ModuleCards(){
	return(
		<>
		<section className="module-cards investor-relations relative pt-[92px]">
		    <div className="container mx-auto px-4">
		        <div className="module-cards-content mt-[-272px]">
		            <div className="row flex flex-wrap -mx-3 gap-y-[24px]">
		                <div className="max-l:w-full max-xl:w-1/2 llg:w-1/3 px-3">
		                    <div className="item bg-white border border-[#c8c8e7] rounded-[20px] max-w-[416px] 
		                    	mx-auto py-[37px] px-[42px] max-md:p-[30px] max-md:gap-[15px] flex max-xxl:flex-col gap-[22px]">
		                        <figure>
		                            <img src="images/investment-case-logo.svg" alt="Icon" className="max-w-[unset]"/>
		                        </figure>
		                        <div className="details">
		                            <h6 className="mb-[12px] text-[#343434] text-xl font-bold">Investment Case</h6>
		                            <p className="max-md:mb-[12px] max-md:text-[15px] mb-[20px] text-[#6d6d6d] text-base leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
		                                Ipsum has been the industry's standard dummy text.</p>
		                            <Link className="primary-link max-l:text-sm text-base !mt-[0px]" href="/#">Learn More</Link>
		                        </div>
		                    </div>
		                </div>
		                <div className="max-l:w-full max-xl:w-1/2 llg:w-1/3 px-3">
		                    <div className="item bg-white border border-[#c8c8e7] rounded-[20px] max-w-[416px] 
		                    	mx-auto py-[37px] px-[42px] max-md:p-[30px] max-md:gap-[15px] flex max-xxl:flex-col gap-[22px]">
		                        <figure>
		                            <img src="images/results-centre-logo.svg" alt="Icon" className="max-w-[unset]"/>
		                        </figure>
		                        <div className="details">
		                            <h6 className="mb-[12px] text-[#343434] text-xl font-bold">Results Centre</h6>
		                            <p className="max-md:mb-[12px] max-md:text-[15px] mb-[20px] text-[#6d6d6d] text-base leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
		                                Ipsum has been the industry's standard dummy text.</p>
		                            <Link className="primary-link max-l:text-sm text-base !mt-[0px]" href="/#">Learn More</Link>
		                        </div>
		                    </div>
		                </div>
		                <div className="max-l:w-full max-xl:w-1/2 llg:w-1/3 px-3">
		                    <div className="item bg-white border border-[#c8c8e7] rounded-[20px] max-w-[416px] 
		                    	mx-auto py-[37px] px-[42px] max-md:p-[30px] max-md:gap-[15px] flex max-xxl:flex-col gap-[22px]">
		                        <figure>
		                            <img src="images/share-evolution-chart-logo.svg" alt="Icon" className="max-w-[unset]" />
		                        </figure>
		                        <div className="details">
		                            <h6 className="mb-[12px] text-[#343434] text-xl font-bold">Share Evolution Chart</h6>
		                            <p className="max-md:mb-[12px] max-md:text-[15px] mb-[20px] text-[#6d6d6d] text-base leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
		                                Ipsum has been the industry's standard dummy text.</p>
		                            <Link className="primary-link max-l:text-sm text-base !mt-[0px]" href="/#">Learn More</Link>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}