import Image from 'next/image'
import Link from 'next/link'

export default function EventsDetails(){
	return(
		<>
		<section className="events-details max-l:pt-[50px] max-xl:pt-[60px] max-xxl:pt-[75px] max-3xl:pt-[80px] pt-[90px] bg-[#eaeef4]">
		    <div className="container mx-auto px-4">
		        <div className="events-details-content bg-[#fefefe] max-l:p-[30px_15px_20px_15px] max-xxl:p-[40px_30px_20px_30px] p-[50px_45px_20px_45px] rounded-[15px]">

		            <div className="item flex max-xl:flex-col justify-between mb-[40px]">
		                <div className="left-side max-xl:w-full w-1/2 relative pb-[40px]">
		                    <span className="sub-heading text-[#000] block max-xl:text-base max-xxl:text-lg text-xl font-bold leading-[1.47]">Live Share Price</span>
		                    <div className="text--area pl-[16px] mt-[13px] border-l-[5px] border-[#713fff]">
		                        <h3 className="text-[#000] max-xl:text-[30px] max-xxl:text-[34px] max-3xl:text-[38px] text-[40px] font-bold leading-[1.51] font-nunito">194.80 GBX</h3>
		                        <span className="block mb-[6px] text-[#000] max-xl:text-[15px] text-base font-medium leading-[1.51]">3.40 | 1.94%</span>
		                        <p className="text-[#808080] max-xl:text-[15px] text-base font-medium leading-[1.51]">LSE | 27-Mar-2024 11:13 GMT</p>
		                    </div>
		                </div>
		                <div className="right-side max-xl:w-full w-1/2 relative pb-[40px] max-xl:pl-[0px] pl-[50px]">
		                    <span className="sub-heading text-[#000] block max-xl:text-base max-xxl:text-lg text-xl font-bold leading-[1.47]">Financial Calendar</span>
		                    <h4 className="mt-[10px] text-[#000] max-xl:text-[20px] max-xxl:text-[22px] max-3xl:text-[24px] text-[26px] font-[300] leading-[1.51]">Upcoming Events</h4>
		                    <ul className="upcoming-events mt-[18px] pl-[16px] border-l-[5px] border-[#713fff]">
		                        <li className="flex items-center gap-[20px]  pb-[8px] mb-[10px] border-b border-[#c4bdd8]">
		                            <div className="event-date text-center text-lg font-semibold leading-[1.14]">
		                            	<span className="block text-[#000] font-normal text-[12px] leading-[1.51]">MAR</span>19</div>
		                            <div className="event-name text-[#000] max-l:text-[15px] max-l:leading-[1.28] text-lg font-normal leading-[1.51]">
		                            	<span className="block text-[13px] font-normal leading-[1.51]">London</span>FY23 preliminary results</div>
		                        </li>
		                        <li className="flex items-center gap-[20px]  pb-[8px] mb-[10px] border-b border-[#c4bdd8]">
		                            <div className="event-date text-center text-lg font-semibold leading-[1.14]">
		                            	<span className="block text-[#000] font-normal text-[12px] leading-[1.51]">MAR</span>19</div>
		                            <div className="event-name text-[#000] max-l:text-[15px] max-l:leading-[1.28] text-lg font-normal leading-[1.51]">
		                            	<span className="block text-[13px] font-normal leading-[1.51]">The Grove</span>Berenberg UK Corporate Conference 2024
		                            </div>
		                        </li>
		                        <li className="flex items-center gap-[20px]  pb-[8px] mb-[10px] border-b border-[#c4bdd8]">
		                            <div className="event-date text-center text-lg font-semibold leading-[1.14]">
		                            	<span className="block text-[#000] font-normal text-[12px] leading-[1.51]">JUL</span>11</div>
		                            <div className="event-name text-[#000] max-l:text-[15px] max-l:leading-[1.28] text-lg font-normal leading-[1.51]">
		                            	<span className="block text-[13px] font-normal leading-[1.51]">RNS</span>H1'24 trading update</div>
		                        </li>
		                    </ul>
		                    <Link href="/#" className="primary-link !mt-[20px] pl-[21px] !text-[12px]">Learn More</Link>
		                </div>
		            </div>
		            <div className="item2 flex max-xl:flex-col justify-between mb-[0px]">
		                <div className="left-side max-xl:w-full w-1/2 relative pb-[0px]">
		                    <span className="sub-heading text-[#000] block max-xl:text-base max-xxl:text-lg text-xl font-bold leading-[1.47]">Download the 2022 Transparency Report</span>
		                    <span className="title text-[#000] text-base font-normal leading-[1.47] ">(updated 11/05/22)</span>
		                    <figure className="mt-[28px] mb-[20px]">
		                        <Image 
		                        	src="/images/transparency-report.png" alt="Image"
		                        	width={407}
		                        	height={185}
		                        	className="block height-auto max-w-[407px] w-full"
		                        />
		                    </figure>
		                </div>
		                <div className="right-side max-xl:w-full w-1/2 relative pb-[40px] max-xl:pl-[0px] pl-[50px]">
		                    <span className="sub-heading text-[#000] block max-xl:text-base max-xxl:text-lg text-xl font-bold leading-[1.47]">RNS</span>
		                    <h4 className="mt-[10px] text-[#000] max-xl:text-xl max-xxl:text-[22px] max-3xl:text-[24px] text-[26px] font-[300] leading-[1.51]">Regulatory Events</h4>

		                    <ul className="regulatory-events mt-[18px] pl-[16px] border-l-[5px] border-[#713fff]">
		                        <li className="pb-[8px] mb-[10px]">
		                            <div className="event-date block text-[#000] text-[13px] font-normal leading-[1.51]">27 March 2024 | 07:10 GMT</div>
		                            <Link href="/#" className="event-name text-[#713fff] max-l:text-[15px] max-l:leading-[1.28] text-base font-normal leading-[1.51] underline">YourReview - Transaction in Own Shares</Link>
		                        </li>
		                        <li className="pb-[8px] mb-[10px]">
		                            <div className="event-date block text-[#000] text-[13px] font-normal leading-[1.51]">26 March 2024 | 07:10 GMT</div>
		                            <Link href="/#" className="event-name text-[#713fff] max-l:text-[15px] max-l:leading-[1.28] text-base font-normal leading-[1.51] underline">YourReview - Transaction in Own Shares</Link>
		                        </li>
		                        <li className="pb-[8px] mb-[10px]">
		                            <div className="event-date block text-[#000] text-[13px] font-normal leading-[1.51]">25 March 2024 | 07:10 GMT</div>
		                            <Link href="/#" className="event-name text-[#713fff] max-l:text-[15px] max-l:leading-[1.28] text-base font-normal leading-[1.51] underline">YourReview - Transaction in Own Shares</Link>
		                        </li>
		                    </ul>
		                    <Link href="/#" className="primary-link !mt-[20px] pl-[21px] !text-[12px]">Learn More</Link>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}