	import Image from 'next/image'
	import Link from 'next/link'
	import { Shadows_Into_Light } from "next/font/google";

	const shadowsIntoLight = Shadows_Into_Light({
		subsets: ["latin"],
		weight: ["400"],
	});

	export default function CeoVision(){
		return(
			<>
			<section className="ceo-vision bg-[#f5f5f5] max-xl:pb-[50px] pb-[105px] mb-[-25px]">
				<div className="container mx-auto px-4">
					<div className="ceo-vision-content">
						<div className="row flex flex-wrap justify-between -mx-3">
							<div className="llg:w-5/12 llg:order-2 px-3">
								<div className="image--area w-full max-w-[520px] relative">
									<Image src="/images/ceo-image.png" alt="ceo-image"
										width={513}
										height={484}
										className="relative z-[10]"
									/>
								</div>
							</div>
							<div className="llg:w-1/2 llg:order-1 px-3">
								<div className="text--area max-xl:pt-[26px] pt-[72px]">
									<span className="block max-xl:mb-[8px] mb-[15px] text-[#713fff] max-xxl:text-base text-lg font-semibold leading-[1.51]">Jhone Deo, CEO</span>
									<h2 className="2xl:text-[48px] font-bold text-[#323232] max-xxl:mb-[8px] mb-[10px]">Vision-Driven Business</h2>
									<p className="mb-[31px] font-medium max-sm:text-sm max-md:text-[15px] max-l:text-base max-xxl:text-[17px] text-lg text-[#707c89] leading-[1.51]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
										has been
										the industry's standard dummy text ever since the 1500s, when an unknown printer took a
										galley
										of type and scrambled it to make a type specimen book.</p>
										<div className="explore w-full max-w-[495px] max-xl:py-[18px] max-xl:px-[22px] py-[22px] px-[30px] rounded-[15px] bg-white">
											<h5 className={`${shadowsIntoLight.className} max-xl:text-[22px] max-xl:leading-[1.30] text-[30px] font-normal 
											leading-[151%] tracking-[1.8px] mb-[10px] text-[#263238]`}>
											Explore our Investment Case</h5>
											<Link className="primary-link with-arrow max-md:text-[16px] !mt-[0px] pr-[80px] !underline" href="/#">Learn More</Link>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
				</>
				);
	}