import Image from 'next/image'
import Link from 'next/link'


export default function HighlightHowWork(){
	return(
		<>
		<section className="highlight-how-work">
			<div className="container mx-auto px-4">
				<div className="section-holder bg-white rounded-[22px] max-md:py-[35px] max-md:px-[30px] py-[60px] px-[66px] mt-[-165px]">
					<div className="our-business-area flex flex-col md:flex-row items-start relative max-md:gap-0 max-xl:gap-2 gap-16">
	              {/* Consumers */}
						<div className="our-business-area--left flex-1 md:text-center md:text-left max-md:border-b max-md:border-[#e7e7e7] max-md:pb-10 max-md:mb-10 pb-[57px]">
							<div className="max-xl:mb-[15px] mb-[30px] flex md:justify-center md:justify-start">
								<Image
									src="/images/icon-primary-consumersr.svg"
									alt="Consumers icon"
									width={68}
									height={68}
									className="max-xl:w-[45px] max-xl:h-[45px]" />
								</div>
								<h3 className="max-sm:text-[28px] max-md:text-[32px] max-xl:text-4xl llg:text-[44px] text-[#323232] font-bold font-nunito mb-[10px]">Consumers</h3>
								<p className="max-sm:text-sm max-md:text-[15px] text-[#707c89] max-xxl:text-[17px] font-medium leading-[1.51] text-lg">
									Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
									has been the industry's standard dummy text ever since the 1500s, when an unknown
									printer took a galley of type and scrambled it to make a type specimen book.
								</p>
							</div>

	              {/* Businesses */}
							<div className="our-business-area--right flex-1 md:text-center md:text-left  pb-[57px] relative 
								before:absolute before:left-0 before:top-0 before:bottom-0 before:w-[1px] before:bg-[#e7e7e7] 
								before:content-[''] before:md:block before:hidden max-md:pl-[0px] max-xl:pl-[40px] pl-[80px]">
								<div className="max-xl:mb-[15px] mb-[30px] flex md:justify-center md:justify-start">
									<Image
										src="/images/icon-primary-business.svg"
										alt="Business icon"
										width={68}
										height={68}
										className="max-xl:w-[45px] max-xl:h-[45px]" />
									</div>
									<h3 className="max-sm:text-[28px] max-md:text-[32px] max-xl:text-4xl llg:text-[44px] text-[#323232] font-bold font-nunito mb-[10px]">Businesses</h3>
									<p className="max-sm:text-sm max-md:text-[15px] text-[#707c89] max-xxl:text-[17px] font-medium leading-[1.51] text-lg">
										Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
										has been the industry's standard dummy text ever since the 1500s, when an unknown
										printer took a galley of type and scrambled it to make a type specimen book.
									</p>
								</div>
							</div>

	            {/* CTA Button */}
							<div className="text-center max-l:mt-[0px] mt-[-4px]">
								<Link
									href="/how-yourreviews-works"
									className="primary-border max-l:text-sm text-[15px] !min-w-[165px] btn-sm inline-block max-l:!py-[16px] !py-[17px] 
									!px-[40px] !border !border-[#713fff] text-[#713fff] font-medium rounded-[49px] hover:bg-[#713fff] 
									hover:text-white"
								>See more about how reviews are collected
								</Link>
							</div>
						</div>

	          {/*Features of YourReview*/}

						<div className="features-cards mt-[85px] mb-20">
							<div className="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-y-5">

								<div className="feature-col px-4">
									<div className="features-card max-w-[289px] max-md:max-w-full max-md:mx-auto max-md:text-center">
										<figure className="h-[70px] max-md:flex max-md:items-center max-md:justify-center">
											<Image
												src="/images/icon-black-globe.svg"
												alt="Being open is in our DNA"
												width={53}
												height={53}
											/>
										</figure>
										<h6 className="text-[#000] text-[24px] font-bold leading-[1.30] mb-[15px] ">Being open is in our DNA</h6>
										<p className="text-[#6d6d6d] leading-relaxed text-base font-normal">
											Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
											been the industry's standard dummy text ever since the 1500s, when an unknown printer took
											a galley of type and scrambled it to make a type specimen book. It has survived not only
											five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.
										</p>
									</div>
								</div>

								<div className="feature-col px-4">
									<div className="features-card max-w-[289px] max-md:max-w-full max-md:mx-auto max-md:text-center">
										<figure className="h-[70px] max-md:flex max-md:items-center max-md:justify-center">
											<Image
												src="/images/icon-black-consumer.svg"
												alt="Consumers own their reviews"
												width={53}
												height={53}
											/>
										</figure>
										<h6 className="text-[#000] text-[24px] font-bold leading-[1.30] mb-[15px] ">Consumers own their reviews</h6>
										<p className="text-[#6d6d6d] leading-relaxed text-base font-normal">
											Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
											been the industry's standard dummy text ever since the 1500s, when an unknown printer took
											a galley of type and scrambled it to make a type specimen book. It has survived not only
											five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.
										</p>
									</div>
								</div>

								<div className="feature-col px-4">
									<div className="features-card max-w-[289px] max-md:max-w-full max-md:mx-auto max-md:text-center">
										<figure className="h-[70px] max-md:flex max-md:items-center max-md:justify-center">
											<Image
												src="/images/icon-black-campain.svg"
												alt="Fighting fake reviews"
												width={53}
												height={53}
											/>
										</figure>
										<h6 className="text-[#000] text-[24px] font-bold leading-[1.30] mb-[15px] ">Fighting fake reviews</h6>
										<p className="text-[#6d6d6d] leading-relaxed text-base font-normal">
											Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
											been the industry's standard dummy text ever since the 1500s, when an unknown printer took
											a galley of type and scrambled it to make a type specimen book. It has survived not only
											five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.
										</p>
									</div>
								</div>

								<div className="feature-col px-4">
									<div className="features-card max-w-[289px] max-md:max-w-full max-md:mx-auto max-md:text-center">
										<figure className="h-[70px] max-md:flex max-md:items-center max-md:justify-center">
											<Image
												src="/images/icon-black-flag.svg"
												alt="Flagging reviews"
												width={53}
												height={53}
											/>
										</figure>
										<h6 className="text-[#000] text-[24px] font-bold leading-[1.30] mb-[15px] ">Flagging reviews</h6>
										<p className="text-[#6d6d6d] leading-relaxed text-base font-normal">
											Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
											been the industry's standard dummy text ever since the 1500s, when an unknown printer took
											a galley of type and scrambled it to make a type specimen book. It has survived not only
											five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.
										</p>
									</div>
								</div>

							</div>
						</div>

	          {/*A neutral space for dialogue and collaboration*/}

						<div className="director-quote pt-[77px] border-t border-[#d0d0d0]">
							<h2 className="max-w-[1109px] mx-auto font-semibold text-center font-inter">
								A neutral space for dialogue and collaboration
							</h2>
							<div className="quote-holder flex max-l:flex-col flex-row mt-[55px]">
								<figure className="flex-shrink-0 mt-[45px] relative z-[1] max-l:mt-0 max-l:flex max-sm:justify-center 
									max-l:justify-end max-sm:mr-[0px] max-l:mr-[30px]">
									<Image
										src="/images/photo-director.png"
										alt="Director photo"
										width={425}
										height={366}
										className="rounded-[12px] object-cover max-l:w-[70%] max-xl:max-w-[320px]"
									/>
								</figure>
								<div className="quote-text max-l:w-[calc(100%+0px)] max-sm:p-[60px_15px_40px_15px] max-l:p-[80px_45px_50px_45px] max-l:ml-[0px] 
									max-l:mt-[-30px] max-l:text-center relative bg-white rounded-[16px] ml-[-60px] 
									w-[calc(100%+60px)] max-xl:p-[70px_70px_85px_100px] max-xxl:p-[80px_80px_80px_120px] p-[105px_105px_85px_180px]">
									<p className="max-w-[607px] max-l:text-lg text-[#000] max-xl:text-2xl text-3xl font-medium leading-[1.53]">
										We welcome everyone. We firmly believe that this is the optimal method to assist consumers
										in making well-informed choices when purchasing products and services”.
									</p>
									<span className="profile-name block mt-[25px] text-[#713fff] font-inter text-xl font-bold leading-[1.53]">Jhone Deo</span>
									<span className="designation block text-[#727272] font-inter text-base font-medium leading-[1.53]">Director of Privacy</span>
								</div>

							</div>
						</div>
					</div>
				</section>
		</>
		);
}