'use client';
import React, { Fragment } from 'react';
import Link from 'next/link'

const ReviewSlider2 = () => {
  return (
    <div className="review-slides2 relative overflow-hidden w-full py-4 group">
      <div className="flex gap-1 animate-marquee-reverse w-max group-hover:[animation-play-state:paused]">
        {[...Array(2)].map((_, index) => (
          <Fragment key={index}>
            {[...Array(9)].map((_, i) => (
              <div key={`${index}-${i}`} className="item flex-shrink-0 w-[26rem] mx-2">
                <div className="review-card">
                  <div className="heading flex space-x-4">
                    <img
                      className="card-profile-image w-12 h-12 rounded-full"
                      src={`/images/profile-image-${i + 1}.jpg`}
                      width={100}
                      height={100}
                      alt={`Reviewer ${i + 1}`}
                    />
                    <div className="profileData flex">
                      <h6 className="name">Gabi Guerra {i + 1}</h6>
                      <span className="status">reviewed Post</span>
                      <Link href="/#" className="post-lake">Lake Lending</Link>
                    </div>
                  </div>
                  <ul className="star-rating flex space-x-1 mb-4">
                    {[...Array(5)].map((_, starIndex) => (
                      <li key={starIndex}>
                        <img src="/images/gray-star_rating.svg" alt={`Star ${starIndex + 1}`} />
                      </li>
                    ))}
                  </ul>
                  <p className="text-sm text-gray-700">
                    Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
                    Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took.
                  </p>
                </div>
              </div>
            ))}
          </Fragment>
        ))}
      </div>
    </div>
  );
};

export default ReviewSlider2;
