'use client';

import { useEffect, useState } from "react";
import Image from "next/image";

// Importing images to get their original dimensions
import obj1 from '../../public/images/object_l1.png';
import obj2 from '../../public/images/object_l2.png';
import obj3 from '../../public/images/object_l_man.png';
import obj4 from '../../public/images/object_l3.png';
import obj5 from '../../public/images/object_b1.png';
import obj6 from '../../public/images/object_r3.png';
import obj7 from '../../public/images/object_b3.png';
import obj8 from '../../public/images/object_b4.png';
import obj9 from '../../public/images/object_b5.png';
import obj10 from '../../public/images/object_r1.png';
import obj11 from '../../public/images/object_r2.png';
import obj12 from '../../public/images/object_r_lady.png';

const images = [
  obj1,
  obj2,
  obj3,
  obj4,
  obj5,
  obj6,
  obj7,
  obj8,
  obj9,
  obj10,
  obj11,
  obj12,
];

export default function HeroBanner() {
  const [scrolled, setScrolled] = useState(false);
  const [showBanner, setShowBanner] = useState(true);

  useEffect(() => {
    const handleScroll = () => {
      const scrollY = window.scrollY;
      setScrolled(scrollY > 420);
      setShowBanner(scrollY <= 1080);
    };

    handleScroll();
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  if (!showBanner) return null;

  return (
    <section className="mainbanner">
      <div
        id="hero-banner-images"
        className={`overlap-images ${scrolled ? "scrolled" : ""}`}
      >
        {images.map((img, index) => (
          <div key={index} className={`img__name object-${index + 1}`}>
            <Image
              className="img__object"
              src={img}
              alt={`object-${index}`}
              width={img.width}
              height={img.height}
              priority
            />
          </div>
        ))}
      </div>
    </section>
  );
}
