import Image from 'next/image'
import Link from 'next/link'


export default function BriefLooks() {
	return (
			<>
			<section className="brief-looks-website">
			  <div className="container mx-auto px-4">
			    <div className="flex flex-col lg:flex-row-reverse gap-8 items-start section-holder">
			      <div className="lg:w-7/12">
			      	<div className="section-content lg:pl-[50px]">
				        <h2 className="mb-[20px]">
				          See How Your Reviews Appear on Your Website
				        </h2>
				        <p className="max-sm:text-[14px] max-md:text-[15px] max-l:text-[16px] max-xxl:text-[17px] 
				        	2xl:text-[18px] lg:tracking-[-0.2px]">
				        	Your.Reviews seamlessly integrates into your website, displaying authentic customer 
				        	feedback in a clean, professional format. Enhance trust and credibility by showcasing 
				        	ratings, detailed reviews, and user-generated content directly on your site, helping 
				        	potential customers make informed decisions effortlessly.
				        </p>
				        <div className="text-center">
				          <Link
				            href="/#"
				            className="ms-btn primary-solid btn-xl primary-button max-l:!text-[16px] max-l:!py-[22px] mt-[45px]
				            hover:bg-[#713fffcc]"
				          >
				            Explore Reviews
				          </Link>
				        </div>
				    </div>
			      </div>
			      <div className="lg:w-5/12 flex justify-center">
			        <Image 
			        	src="images/image-looks_on_website.svg" alt="How it looks"
			        	width={500}
			        	height={445}
			        	className="w-full max-w-[480px] h-auto section-image" />
			      </div>
			    </div>
			  </div>
			</section>
			</>
		);
}