import Link from 'next/link';
import Image from 'next/image';
import MobileHeader from './MobileHeader';

const DefaultHeader = () => (
  <>
    <header className="DefaultHeader w-full py-3 px-[34px] absolute">
      <div className="container mx-auto px-4">
        <div className="header-holder flex justify-between">
          {/* Logo */}
          <div className="logo w-1/4">
            <Link href="/">
              <Image
                src="/images/logo-your-reivew.png"
                alt="Logo"
                width={183}
                height={52}
                className="main-logo object-contain"
              />
            </Link>
          </div>

          {/* Left Menu */}
          <div className="flex items-center">
            <ul className="menulist-left flex items-center">
              <li>
                <Link href="/pricing" className="text-[#323232] hover:text-[#713fff]">Plans</Link>
              </li>
              <li>
                <Link href="/customer-stories" className="text-[#323232] hover:text-[#713fff]">Reviews</Link>
              </li>
              <li>
                <Link href="/webinars" className="text-[#323232] hover:text-[#713fff]">Resources</Link>
              </li>
              <li>
                <Link href="/our-story" className="text-[#323232] hover:text-[#713fff]">About</Link>
              </li>
            </ul>
          </div>

          {/* Right Menu */}
          <div className="flex justify-end w-1/4">
            <ul className="menulist-right flex items-center gap-[5px]">
              <li className="first:border-r first:border-solid first:border-[rgba(50,50,50,0.5)]">
                <Link href="/customer-register-login" className="text-[#323232] hover:text-[#713fff]">Join</Link>
              </li>
              <li>
                <Link href="/business-registration-login" className="text-[#323232] hover:text-[#713fff]">Sign in</Link>
              </li>
              <li>
                <Link href="/business-registration-login" className="ms-btn primary-solid btn-sm !min-w-0 !text-white
                  hover:bg-[#713fffcc]">Business</Link>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </header>
    <MobileHeader />
  </>
);

export default DefaultHeader;
