import Link from 'next/link'

export default function InnerBanner(){
	return(
		<>
		<section className="inner-banner contact-banner pt-[140px] max-sm:pb-[50px] max-md:pb-[60px] 
			max-xxl:pb-[80px] llg:pb-[80px] text-center">
		    <div className="container mx-auto px-4">
		        <h1 className="mb-[35px] max-sm:max-w-[320px] max-sm:mx-auto 
		        	max-sm:text-[36px] max-xl:text-[54px] font-extrabold !leading-[1.08]">
		        	Contact Sales
		        </h1>
		        <p className="max-l:text-base text-xl text-[#6d6d6d] font-medium text-center !leading-[1.47]">
		        	Complete the form below or give us a call: 
		        	<Link className="phone-number text-[#2e2c2c] max-l:block" href="tel:1 000-000-3000"> +1 000-000-3000.
		        	</Link>
		        </p>
		        <p className="max-l:text-base text-xl text-[#6d6d6d] font-medium text-center !leading-[1.47]">
		        	For support related questions, 
		        	<Link className="form-link text-[#713fff] max-l:block" href="/#"> please use this form instead.
			        </Link>
		        </p>
		    </div>
		</section>
		</>
		);
}