'use client';

import { useEffect, useRef } from 'react';
import intlTelInput from 'intl-tel-input';
import 'intl-tel-input/build/css/intlTelInput.css';

type IntlTelInputInstance = {
  destroy: () => void;
};

const PhoneInput = () => {
  const inputRef = useRef<HTMLInputElement>(null);
  const itiRef = useRef<IntlTelInputInstance | null>(null);

  useEffect(() => {
    if (!inputRef.current) return;

    const options = {
      initialCountry: 'us',
      separateDialCode: true,
      preferredCountries: ['us', 'gb'],
      geoIpLookup: (callback: (countryCode: string) => void) => {
        fetch('https://ipapi.co/json')
          .then((res) => res.json())
          .then((data) => callback(data.country_code))
          .catch(() => callback('us'));
      },
      utilsScript:
        'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js',
    } as any; // 👈 Cast to `any` to avoid type errors

    const iti = intlTelInput(inputRef.current, options);
    itiRef.current = iti as unknown as IntlTelInputInstance;

    // Reorder dial code and arrow for better UX
    setTimeout(() => {
      const container = inputRef.current?.closest('.iti');
      if (!container) return;

      const flagContainer = container.querySelector('.iti__flag-container');
      const dialCode = container.querySelector('.iti__selected-dial-code');
      const arrow = container.querySelector('.iti__arrow');

      if (flagContainer && dialCode && arrow) {
        const dialWrap = document.createElement('div');
        dialWrap.className = 'dial-arrow-wrapper';
        dialWrap.style.display = 'flex';
        dialWrap.style.alignItems = 'center';

        dialWrap.appendChild(dialCode);
        dialWrap.appendChild(arrow);
        flagContainer.appendChild(dialWrap);
      }
    }, 200);

    return () => {
      itiRef.current?.destroy();
    };
  }, []);

  return (
    <input
      ref={inputRef}
      type="tel"
      name="phone"
      placeholder="Phone Number"
      className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"
    />
  );
};

export default PhoneInput;
