import Image from 'next/image'
import Link from 'next/link'

export default function DetailHeader(){
	return(
		<>
		<section className="review-detail-header max-xl:pt-[140px] pt-[80px]">
		    <div className="container mx-auto px-4">
		        <div className="section-holder flex max-md:flex-col max-md:gap-y-[25px] justify-between">
		            <div className="section-holder--left flex max-sm:flex-col items-start max-md:gap-[15px] gap-[43px]">
		                <Image 
		                	className="card-image max-md:w-[120px] w-[162px]" 
		                	src="/images/love-book-logo.png" alt="Logo"
		                	width={243} 
		                	height={243} 
		                />
		                <div className="business-name">
		                    <h4 className="flex flex-wrap items-center max-md:gap-x-[5px] gap-y-[10px] gap-x-[20px] text-[#343434] 
		                    	max-md:text-[26px] text-[32px] font-extrabold leading-[1.07]">LoveBook 
		                    	<span className="verified-label inline-block pl-[28px] pr-[13px] rounded-[100px]
		                    		border border-[#713fff] text-[#713fff] text-[12px] font-bold leading-[27px] relative
		                    		max-md:text-[0px] max-md:p-0 max-md:h-[28px] max-md:w-[28px] max-md:leading-[28px] 
		                    		max-md:text-center">
		                    		Verified company
		                    	</span>
		                    </h4>
		                    <span className="location flex items-center mt-[9px] gap-[3px] text-[#737373] 
		                    	max-md:text-[13px] max-l:text-[14px] text-base font-normal leading-[1.07]">
		                    	<i className="icon-location"></i>
		                    	Irvine, United States
		                    </span>
		                    <div className="review-actions">
		                        <div className="star-icons inline-flex items-center p-[13px_32px_13px_25px] rounded-[100px] 
		                    	bg-[#f9f6ff] max-xl:py-[8px] max-xl:px-[15px] max-l:mt-[15px] mt-[28px]">
		                            <ul className="flex items-center gap-[2px] w-auto p-0 mr-[20px] rounde-[50px] leading-0
		                            	max-md:py-[4px] max-md:px-[7px]">
		                                <li><img className="star-rating-icon max-xl:h-[24px] h-[34px]" src="images/rating-star-full.svg" alt=""/></li>
		                                <li><img className="star-rating-icon max-xl:h-[24px] h-[34px]" src="images/rating-star-full.svg" alt=""/></li>
		                                <li><img className="star-rating-icon max-xl:h-[24px] h-[34px]" src="images/rating-star-full.svg" alt=""/></li>
		                                <li><img className="star-rating-icon max-xl:h-[24px] h-[34px]" src="images/rating-star-half.svg" alt=""/></li>
		                                <li><img className="star-rating-icon max-xl:h-[24px] h-[34px]" src="images/rating-star-blank.svg" alt=""/></li>
		                            </ul>
		                            <span className="review_count text-[#737373] text-xl font-normal leading-[1.07]">
		                            	4.7
		                            </span>
		                        </div>
		                    </div>
		                </div>
		            </div>
		            <div className="section-holder--right">
		                <div className="product-website relative p-[10px_0px_10px_37px]">
		                    <i className="icon-attach-light absolute left-0 max-md:text-[36px] text-[42px] text-[#713fff]"></i>
		                    <label className="light-label block text-[#6a6a6a] text-sm font-normal leading-[1.07]">
		                    	Visit this website
		                    </label>
		                    <Link className="website-link text-[#713fff] text-base font-bold leading-[1.07] underline" 
		                    	href="http://www.lovebookonline.com">
		                    	www.lovebookonline.com
		                    </Link>
		                </div>
		                <div className="reviews flex items-center max-md:gap-[15px] gap-[30px] mt-[30px]">
		                    <h6 className="text-[#737373] max-md:text-[14px] text-base font-normal leading-[1.07]">YourReview Score
		                    	<span className="block mt-[2px] text-[#343434] max-md:text-[24px] text-[32px] font-normal leading-[]1.07">
		                    		5.0</span>
		                    </h6>
		                    <div className="break h-[48px] w-[1px] bg-[#d1cddf]"></div>
		                    <h6 className="text-[#737373] max-md:text-[14px] text-base font-normal leading-[1.07]">Reviews
		                    	<span className="block mt-[2px] text-[#343434] max-md:text-[24px] text-[32px] font-normal leading-[]1.07">
		                    		1,924
		                    	</span>
		                    </h6>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}